/*
 * Decompiled with CFR 0.152.
 */
package jetm;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import jetm.Dlg;
import jetm.EtmUdp;
import jetm.Lib;
import jetm.TABLE;

public class etm
extends JFrame {
    public static String[][] m_Txt = new String[100][6];
    public static int m_Rows = 0;
    public static byte[][] m_Data = new byte[100][20];
    public static int m_tmRefresh = 0;
    TABLE m_Table = new TABLE();
    private JMenuItem jBrowse;
    private JMenuItem jBrowse2;
    private JMenu jConfig;
    private JMenuItem jExit;
    private JMenuItem jIP;
    private JMenuItem jIP2;
    private JScrollPane jPane;
    private JPopupMenu jPopupMenu;
    private JMenuItem jPrint;
    private JMenuItem jRefresh;
    private JMenuBar jSystemMenu;
    private JTable jTable;
    private JMenu jView;

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                etm etm2 = new etm();
                etm2.pack();
                etm2.setVisible(true);
            }
        });
    }

    public etm() {
        this.initComponents();
        this.jTable.setModel(this.m_Table);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (m_tmRefresh <= 0) {
                    return;
                }
                if (m_tmRefresh > 20) {
                    m_tmRefresh = 0;
                    etm.this.Refresh();
                } else {
                    ++m_tmRefresh;
                }
            }
        };
        new Timer(1000, actionListener).start();
    }

    public void Refresh() {
        EtmUdp etmUdp = new EtmUdp();
        etmUdp.GetList();
        int[] nArray = new int[]{100, 120, 160, 50};
        for (int i = 0; i < 4; ++i) {
            TableColumn tableColumn = this.jTable.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(nArray[i]);
        }
        this.jTable.getRowSorter().allRowsChanged();
        this.jTable.updateUI();
    }

    public void Config() {
        if (m_Rows <= 0) {
            return;
        }
        int n = this.jTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        n = this.jTable.convertRowIndexToModel(n);
        String string = String.format("http://%s", m_Txt[n][0]);
        Lib.openURL(string);
    }

    public void SetDevice() {
        int n;
        if (m_Rows <= 0) {
            return;
        }
        int n2 = this.jTable.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        n2 = this.jTable.convertRowIndexToModel(n2);
        Dlg dlg = new Dlg((Frame)this, m_Txt[n2][0], m_Txt[n2][1]);
        dlg.setLocationRelativeTo(this.jPane);
        dlg.setVisible(true);
        if (!dlg.bOk) {
            return;
        }
        if (dlg.IP.equals(m_Txt[n2][0]) && dlg.Mask.equals(m_Txt[n2][1])) {
            return;
        }
        boolean bl = true;
        byte[] byArray = Lib.Str2IP(dlg.IP);
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
            bl = false;
        }
        if ((n = byArray[0] & 0xFF) >= 224 || n == 127) {
            bl = false;
        }
        if ((byArray[3] & 0xFF) == 255) {
            bl = false;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this, "Invalid IP Address", "Device Setting", 0);
            return;
        }
        byte[] byArray2 = Lib.Str2IP(dlg.Mask);
        if (byArray2[0] != -1) {
            bl = false;
        }
        if (byArray2[3] == -1) {
            bl = false;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this, "Invalid subnet mask", "Device Setting", 0);
            return;
        }
        EtmUdp etmUdp = new EtmUdp();
        if (!dlg.Password.isEmpty()) {
            etmUdp.SetPwd(n2, dlg.Password);
        }
        if (!dlg.IP.equals(m_Txt[n2][0])) {
            etmUdp.SetIP(n2, byArray);
        }
        if (!dlg.Mask.equals(m_Txt[n2][1])) {
            etmUdp.SetMask(n2, byArray2);
        }
        m_tmRefresh = 8;
    }

    private void initComponents() {
        this.jPopupMenu = new JPopupMenu();
        this.jIP2 = new JMenuItem();
        this.jBrowse2 = new JMenuItem();
        this.jPane = new JScrollPane();
        this.jTable = new JTable();
        this.jSystemMenu = new JMenuBar();
        this.jView = new JMenu();
        this.jRefresh = new JMenuItem();
        this.jPrint = new JMenuItem();
        this.jExit = new JMenuItem();
        this.jConfig = new JMenu();
        this.jIP = new JMenuItem();
        this.jBrowse = new JMenuItem();
        this.jIP2.setMnemonic('I');
        this.jIP2.setText("Set IP Address");
        this.jIP2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                etm.this.jIP2ActionPerformed(actionEvent);
            }
        });
        this.jPopupMenu.add(this.jIP2);
        this.jBrowse2.setMnemonic('B');
        this.jBrowse2.setText("Launch Browser");
        this.jBrowse2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                etm.this.jBrowse2ActionPerformed(actionEvent);
            }
        });
        this.jPopupMenu.add(this.jBrowse2);
        this.setDefaultCloseOperation(3);
        this.setTitle("Java Ethernet Manager 2.0");
        this.setFont(new Font("DejaVu Sans", 0, 18));
        this.setLocationByPlatform(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                etm.this.formWindowOpened(windowEvent);
            }
        });
        this.jPane.setFont(new Font("DejaVu Serif", 0, 18));
        this.jTable.setAutoCreateRowSorter(true);
        this.jTable.setFont(new Font("Arial", 0, 14));
        this.jTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"IP Address", "Subnet", "MAC", "Device ID", "Name", "Model"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, Integer.class, Object.class, Object.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jTable.setComponentPopupMenu(this.jPopupMenu);
        this.jTable.setEditingColumn(0);
        this.jTable.setEditingRow(0);
        this.jTable.setFillsViewportHeight(true);
        this.jTable.setMinimumSize(new Dimension(50, 0));
        this.jTable.setOpaque(false);
        this.jTable.setPreferredSize(new Dimension(50, 0));
        this.jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                etm.this.jTableMousePressed(mouseEvent);
            }
        });
        this.jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                etm.this.jTableKeyPressed(keyEvent);
            }
        });
        this.jPane.setViewportView(this.jTable);
        this.jSystemMenu.setFont(new Font("DejaVu Serif", 0, 18));
        this.jView.setMnemonic('V');
        this.jView.setText("View");
        this.jRefresh.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.jRefresh.setMnemonic('R');
        this.jRefresh.setText("Refresh");
        this.jRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                etm.this.jRefreshActionPerformed(actionEvent);
            }
        });
        this.jView.add(this.jRefresh);
        this.jPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.jPrint.setMnemonic('P');
        this.jPrint.setText("Print");
        this.jPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                etm.this.jPrintActionPerformed(actionEvent);
            }
        });
        this.jView.add(this.jPrint);
        this.jExit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.jExit.setMnemonic('X');
        this.jExit.setText("Exit");
        this.jExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                etm.this.jExitActionPerformed(actionEvent);
            }
        });
        this.jView.add(this.jExit);
        this.jSystemMenu.add(this.jView);
        this.jConfig.setMnemonic('C');
        this.jConfig.setText("Config");
        this.jIP.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.jIP.setMnemonic('I');
        this.jIP.setText("Set IP Address");
        this.jIP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                etm.this.jIPActionPerformed(actionEvent);
            }
        });
        this.jConfig.add(this.jIP);
        this.jBrowse.setAccelerator(KeyStroke.getKeyStroke(10, 8));
        this.jBrowse.setMnemonic('B');
        this.jBrowse.setText("Launch Browser");
        this.jBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                etm.this.jBrowseActionPerformed(actionEvent);
            }
        });
        this.jConfig.add(this.jBrowse);
        this.jSystemMenu.add(this.jConfig);
        this.setJMenuBar(this.jSystemMenu);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jPane, -1, 614, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jPane, -1, 306, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jBrowse2ActionPerformed(ActionEvent actionEvent) {
        this.Config();
    }

    private void jIP2ActionPerformed(ActionEvent actionEvent) {
        this.SetDevice();
    }

    private void jTableKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.isAltDown()) {
            return;
        }
        if (keyEvent.getKeyCode() == 10) {
            keyEvent.setKeyCode(0);
            this.SetDevice();
        }
    }

    private void jPrintActionPerformed(ActionEvent actionEvent) {
        try {
            this.jTable.print();
        }
        catch (PrinterException printerException) {
            JOptionPane.showMessageDialog(this, "Printer error", "Error", 0);
        }
    }

    private void jTableMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() < 2) {
            return;
        }
        this.Config();
    }

    private void formWindowOpened(WindowEvent windowEvent) {
        this.Refresh();
        this.jTable.getRowSorter().toggleSortOrder(0);
    }

    private void jBrowseActionPerformed(ActionEvent actionEvent) {
        this.Config();
    }

    private void jIPActionPerformed(ActionEvent actionEvent) {
        this.SetDevice();
    }

    private void jRefreshActionPerformed(ActionEvent actionEvent) {
        this.Refresh();
    }

    private void jExitActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }
}

