/*
 * Decompiled with CFR 0.152.
 */
package jetm;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import jetm.Lib;
import jetm.etm;

class EtmUdp {
    static DatagramSocket m_Skt = null;
    static InetAddress m_Addr = null;
    static boolean m_bInit = false;
    byte[] tdata = new byte[128];
    byte[] rdata = new byte[128];
    byte[] sName = new byte[20];
    byte[] sModel = new byte[20];

    public EtmUdp() {
        if (m_bInit) {
            return;
        }
        try {
            m_Addr = InetAddress.getByName("255.255.255.255");
            m_Skt = new DatagramSocket(0);
            m_Skt.setBroadcast(true);
            m_Skt.setSoTimeout(100);
            m_bInit = true;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void GetList() {
        DatagramPacket datagramPacket;
        int n;
        byte[] byArray;
        try {
            byArray = this.tdata;
            byArray[0] = 67;
            byArray[1] = 33;
            byArray[2] = 48;
            byArray[3] = 57;
            for (n = 4; n < 20; ++n) {
                byArray[n] = 0;
            }
            datagramPacket = new DatagramPacket(byArray, 20, m_Addr, 36);
            m_Skt.send(datagramPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        etm.m_Rows = 0;
        n = 0;
        while (n < 100) {
            byArray = this.rdata;
            try {
                int n2;
                datagramPacket = new DatagramPacket(byArray, 128, m_Addr, 36);
                m_Skt.receive(datagramPacket);
                int n3 = datagramPacket.getLength();
                if (n3 != 20 && n3 != 128 || (n2 = (byArray[0] & 0xFF) << 8 | byArray[1]) != 17185 || (n2 = (byArray[2] & 0xFF) << 8 | byArray[3]) != 12345) continue;
                etm.m_Txt[n][0] = String.format("%d.%d.%d.%d", byArray[4] & 0xFF, byArray[5] & 0xFF, byArray[6] & 0xFF, byArray[7] & 0xFF);
                etm.m_Txt[n][1] = String.format("%d.%d.%d.%d", byArray[8] & 0xFF, byArray[9] & 0xFF, byArray[10] & 0xFF, byArray[11] & 0xFF);
                etm.m_Txt[n][2] = String.format("%02X-%02X-%02X-%02X-%02X-%02X", byArray[12], byArray[13], byArray[14], byArray[15], byArray[16], byArray[17]);
                n2 = (byArray[18] & 0xFF) << 8;
                etm.m_Txt[n][3] = String.format("%d", n2 |= byArray[19] & 0xFF);
                etm.m_Txt[n][4] = "";
                etm.m_Txt[n][5] = "";
                if (n3 == 128) {
                    System.arraycopy(byArray, 20, this.sName, 0, 18);
                    System.arraycopy(byArray, 40, this.sModel, 0, 18);
                    etm.m_Txt[n][4] = new String(this.sName, 0, Lib.strlen(this.sName));
                    etm.m_Txt[n][5] = new String(this.sModel, 0, Lib.strlen(this.sModel));
                }
                System.arraycopy(byArray, 0, etm.m_Data[n], 0, 20);
                ++n;
            }
            catch (IOException iOException) {
                // empty catch block
                break;
            }
        }
        etm.m_Rows = n;
    }

    public void SetIP(int n, byte[] byArray) {
        System.arraycopy(etm.m_Data[n], 0, this.tdata, 0, 20);
        System.arraycopy(byArray, 0, this.tdata, 4, 4);
        try {
            byte[] byArray2 = this.tdata;
            byArray2[0] = 67;
            byArray2[1] = 33;
            byArray2[2] = 48;
            byArray2[3] = 58;
            DatagramPacket datagramPacket = new DatagramPacket(byArray2, 20, m_Addr, 36);
            m_Skt.send(datagramPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void SetMask(int n, byte[] byArray) {
        System.arraycopy(etm.m_Data[n], 0, this.tdata, 0, 20);
        System.arraycopy(byArray, 0, this.tdata, 8, 4);
        try {
            byte[] byArray2 = this.tdata;
            byArray2[0] = 67;
            byArray2[1] = 33;
            byArray2[2] = 48;
            byArray2[3] = 59;
            DatagramPacket datagramPacket = new DatagramPacket(byArray2, 20, m_Addr, 36);
            m_Skt.send(datagramPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void SetPwd(int n, String string) {
        if (string.length() <= 0) {
            return;
        }
        byte[] byArray = string.getBytes();
        for (int i = 0; i < 128; ++i) {
            this.tdata[i] = 0;
        }
        byte[] byArray2 = this.tdata;
        byArray2[0] = 67;
        byArray2[1] = 33;
        byArray2[2] = 48;
        byArray2[3] = 63;
        byArray2[4] = 3;
        byArray2[5] = 6;
        System.arraycopy(etm.m_Data[n], 12, byArray2, 6, 6);
        byArray2[12] = 5;
        byArray2[13] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 14, byArray.length);
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray2, 104, m_Addr, 36);
            m_Skt.send(datagramPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

