#!/bin/sh
# This script was generated using Makeself 2.1.5

CRCsum="3671936558"
MD5="a7c3e63af9245d52db7085362f17ce4c"
TMPROOT=${TMPDIR:=/tmp}

label="Systembase PCI/PCIe device drvier installer"
script="./Install"
scriptargs=""
targetdir="sysbas_mpdrv.v22.0"
filesizes="31976"
keep=y

print_cmd_arg=""
if type printf > /dev/null; then
    print_cmd="printf"
elif test -x /usr/ucb/echo; then
    print_cmd="/usr/ucb/echo"
else
    print_cmd="echo"
fi

unset CDPATH

MS_Printf()
{
    $print_cmd $print_cmd_arg "$1"
}

MS_Progress()
{
    while read a; do
	MS_Printf .
    done
}

MS_diskspace()
{
	(
	if test -d /usr/xpg4/bin; then
		PATH=/usr/xpg4/bin:$PATH
	fi
	df -kP "$1" | tail -1 | awk '{print $4}'
	)
}

MS_dd()
{
    blocks=`expr $3 / 1024`
    bytes=`expr $3 % 1024`
    dd if="$1" ibs=$2 skip=1 obs=1024 conv=sync 2> /dev/null | \
    { test $blocks -gt 0 && dd ibs=1024 obs=1024 count=$blocks ; \
      test $bytes  -gt 0 && dd ibs=1 obs=1024 count=$bytes ; } 2> /dev/null
}

MS_Help()
{
    cat << EOH >&2
Makeself version 2.1.5
 1) Getting help or info about $0 :
  $0 --help   Print this message
  $0 --info   Print embedded info : title, default target directory, embedded script ...
  $0 --lsm    Print embedded lsm entry (or no LSM)
  $0 --list   Print the list of files in the archive
  $0 --check  Checks integrity of the archive
 
 2) Running $0 :
  $0 [options] [--] [additional arguments to embedded script]
  with following options (in that order)
  --confirm             Ask before running embedded script
  --noexec              Do not run embedded script
  --keep                Do not erase target directory after running
			the embedded script
  --nox11               Do not spawn an xterm
  --nochown             Do not give the extracted files to the current user
  --target NewDirectory Extract in NewDirectory
  --tar arg1 [arg2 ...] Access the contents of the archive through the tar command
  --                    Following arguments will be passed to the embedded script
EOH
}

MS_Check()
{
    OLD_PATH="$PATH"
    PATH=${GUESS_MD5_PATH:-"$OLD_PATH:/bin:/usr/bin:/sbin:/usr/local/ssl/bin:/usr/local/bin:/opt/openssl/bin"}
	MD5_ARG=""
    MD5_PATH=`exec <&- 2>&-; which md5sum || type md5sum`
    test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which md5 || type md5`
	test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which digest || type digest`
    PATH="$OLD_PATH"

    MS_Printf "Verifying archive integrity..."
    offset=`head -n 402 "$1" | wc -c | tr -d " "`
    verb=$2
    i=1
    for s in $filesizes
    do
		crc=`echo $CRCsum | cut -d" " -f$i`
		if test -x "$MD5_PATH"; then
			if test `basename $MD5_PATH` = digest; then
				MD5_ARG="-a md5"
			fi
			md5=`echo $MD5 | cut -d" " -f$i`
			if test $md5 = "00000000000000000000000000000000"; then
				test x$verb = xy && echo " $1 does not contain an embedded MD5 checksum." >&2
			else
				md5sum=`MS_dd "$1" $offset $s | eval "$MD5_PATH $MD5_ARG" | cut -b-32`;
				if test "$md5sum" != "$md5"; then
					echo "Error in MD5 checksums: $md5sum is different from $md5" >&2
					exit 2
				else
					test x$verb = xy && MS_Printf " MD5 checksums are OK." >&2
				fi
				crc="0000000000"; verb=n
			fi
		fi
		if test $crc = "0000000000"; then
			test x$verb = xy && echo " $1 does not contain a CRC checksum." >&2
		else
			sum1=`MS_dd "$1" $offset $s | CMD_ENV=xpg4 cksum | awk '{print $1}'`
			if test "$sum1" = "$crc"; then
				test x$verb = xy && MS_Printf " CRC checksums are OK." >&2
			else
				echo "Error in checksums: $sum1 is different from $crc"
				exit 2;
			fi
		fi
		i=`expr $i + 1`
		offset=`expr $offset + $s`
    done
    echo " All good."
}

UnTAR()
{
    tar $1vf - 2>&1 || { echo Extraction failed. > /dev/tty; kill -15 $$; }
}

finish=true
xterm_loop=
nox11=n
copy=none
ownership=y
verbose=n

initargs="$@"

while true
do
    case "$1" in
    -h | --help)
	MS_Help
	exit 0
	;;
    --info)
	echo Identification: "$label"
	echo Target directory: "$targetdir"
	echo Uncompressed size: 200 KB
	echo Compression: bzip2
	echo Date of packaging: Tue Jul 31 11:53:20 KST 2018
	echo Built with Makeself version 2.1.5 on linux-gnu
	echo Build command was: "./makeself-2.1.6/makeself.sh \\
    \"--bzip2\" \\
    \"sysbas_mpdrv.v22.0\" \\
    \"sysbas_mpdrv.v22.0.sh\" \\
    \"Systembase PCI/PCIe device drvier installer\" \\
    \"./Install\""
	if test x$script != x; then
	    echo Script run after extraction:
	    echo "    " $script $scriptargs
	fi
	if test x"" = xcopy; then
		echo "Archive will copy itself to a temporary location"
	fi
	if test x"y" = xy; then
	    echo "directory $targetdir is permanent"
	else
	    echo "$targetdir will be removed after extraction"
	fi
	exit 0
	;;
    --dumpconf)
	echo LABEL=\"$label\"
	echo SCRIPT=\"$script\"
	echo SCRIPTARGS=\"$scriptargs\"
	echo archdirname=\"sysbas_mpdrv.v22.0\"
	echo KEEP=y
	echo COMPRESS=bzip2
	echo filesizes=\"$filesizes\"
	echo CRCsum=\"$CRCsum\"
	echo MD5sum=\"$MD5\"
	echo OLDUSIZE=200
	echo OLDSKIP=403
	exit 0
	;;
    --lsm)
cat << EOLSM
No LSM.
EOLSM
	exit 0
	;;
    --list)
	echo Target directory: $targetdir
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | UnTAR t
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
	--tar)
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	arg1="$2"
	shift 2
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | tar "$arg1" - $*
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
    --check)
	MS_Check "$0" y
	exit 0
	;;
    --confirm)
	verbose=y
	shift
	;;
	--noexec)
	script=""
	shift
	;;
    --keep)
	keep=y
	shift
	;;
    --target)
	keep=y
	targetdir=${2:-.}
	shift 2
	;;
    --nox11)
	nox11=y
	shift
	;;
    --nochown)
	ownership=n
	shift
	;;
    --xwin)
	finish="echo Press Return to close this window...; read junk"
	xterm_loop=1
	shift
	;;
    --phase2)
	copy=phase2
	shift
	;;
    --)
	shift
	break ;;
    -*)
	echo Unrecognized flag : "$1" >&2
	MS_Help
	exit 1
	;;
    *)
	break ;;
    esac
done

case "$copy" in
copy)
    tmpdir=$TMPROOT/makeself.$RANDOM.`date +"%y%m%d%H%M%S"`.$$
    mkdir "$tmpdir" || {
	echo "Could not create temporary directory $tmpdir" >&2
	exit 1
    }
    SCRIPT_COPY="$tmpdir/makeself"
    echo "Copying to a temporary location..." >&2
    cp "$0" "$SCRIPT_COPY"
    chmod +x "$SCRIPT_COPY"
    cd "$TMPROOT"
    exec "$SCRIPT_COPY" --phase2 -- $initargs
    ;;
phase2)
    finish="$finish ; rm -rf `dirname $0`"
    ;;
esac

if test "$nox11" = "n"; then
    if tty -s; then                 # Do we have a terminal?
	:
    else
        if test x"$DISPLAY" != x -a x"$xterm_loop" = x; then  # No, but do we have X?
            if xset q > /dev/null 2>&1; then # Check for valid DISPLAY variable
                GUESS_XTERMS="xterm rxvt dtterm eterm Eterm kvt konsole aterm"
                for a in $GUESS_XTERMS; do
                    if type $a >/dev/null 2>&1; then
                        XTERM=$a
                        break
                    fi
                done
                chmod a+x $0 || echo Please add execution rights on $0
                if test `echo "$0" | cut -c1` = "/"; then # Spawn a terminal!
                    exec $XTERM -title "$label" -e "$0" --xwin "$initargs"
                else
                    exec $XTERM -title "$label" -e "./$0" --xwin "$initargs"
                fi
            fi
        fi
    fi
fi

if test "$targetdir" = "."; then
    tmpdir="."
else
    if test "$keep" = y; then
	echo "Creating directory $targetdir" >&2
	tmpdir="$targetdir"
	dashp="-p"
    else
	tmpdir="$TMPROOT/selfgz$$$RANDOM"
	dashp=""
    fi
    mkdir $dashp $tmpdir || {
	echo 'Cannot create target directory' $tmpdir >&2
	echo 'You should try option --target OtherDirectory' >&2
	eval $finish
	exit 1
    }
fi

location="`pwd`"
if test x$SETUP_NOCHECK != x1; then
    MS_Check "$0"
fi
offset=`head -n 402 "$0" | wc -c | tr -d " "`

if test x"$verbose" = xy; then
	MS_Printf "About to extract 200 KB in $tmpdir ... Proceed ? [Y/n] "
	read yn
	if test x"$yn" = xn; then
		eval $finish; exit 1
	fi
fi

MS_Printf "Uncompressing $label"
res=3
if test "$keep" = n; then
    trap 'echo Signal caught, cleaning up >&2; cd $TMPROOT; /bin/rm -rf $tmpdir; eval $finish; exit 15' 1 2 3 15
fi

leftspace=`MS_diskspace $tmpdir`
if test $leftspace -lt 200; then
    echo
    echo "Not enough space left in "`dirname $tmpdir`" ($leftspace KB) to decompress $0 (200 KB)" >&2
    if test "$keep" = n; then
        echo "Consider setting TMPDIR to a directory with more free space."
   fi
    eval $finish; exit 1
fi

for s in $filesizes
do
    if MS_dd "$0" $offset $s | eval "bzip2 -d" | ( cd "$tmpdir"; UnTAR x ) | MS_Progress; then
		if test x"$ownership" = xy; then
			(PATH=/usr/xpg4/bin:$PATH; cd "$tmpdir"; chown -R `id -u` .;  chgrp -R `id -g` .)
		fi
    else
		echo
		echo "Unable to decompress $0" >&2
		eval $finish; exit 1
    fi
    offset=`expr $offset + $s`
done
echo

cd "$tmpdir"
res=0
if test x"$script" != x; then
    if test x"$verbose" = xy; then
		MS_Printf "OK to execute: $script $scriptargs $* ? [Y/n] "
		read yn
		if test x"$yn" = x -o x"$yn" = xy -o x"$yn" = xY; then
			eval $script $scriptargs $*; res=$?;
		fi
    else
		eval $script $scriptargs $*; res=$?
    fi
    if test $res -ne 0; then
		test x"$verbose" = xy && echo "The program '$script' returned an error code ($res)" >&2
    fi
fi
if test "$keep" = n; then
    cd $TMPROOT
    /bin/rm -rf $tmpdir
fi
eval $finish; exit $res
BZh91AY&SY4 Q@   0  )`{[>}   <)PՠQYnK!Y=y
yy8ww>:;}zuw{kz5ig[{VaD  -ݞ}wχϾމy}xן{}k[7U}:P)v7{޽&
ve赶is{|{}nϾV׽4	uQce}<U]iC7voM}mm{njuQf.9-{q닡-Yn_{ov&wYOwﻁ9A:w&۴u8񥫷uJ7{0|«}^ϾUΊW<ܶ}y}{ޓ6·d.B  h ɣ &5O!1zd1
 	MDjb))&FM4Hhzj DD
M4S4Sb(zѣ= h(COH!H 4e3ASjzC&S򧐟aMPd@@4 DLdɠDɡ55=#Hi=5=4#Fh2 h$COCSbl➧=
M     SWf#/PwcIO=yI (X9@T%*`|g¥n}}Ur`[86왿cu3Ȝ
BKJ8g$PP5Vۚٛzޝśv{&
G9,1d(
АbAH@C@ӈ٘Jd m1X*@9I Ҳj_ ʈ2
׏?L@HI%tv"T>yH㈇DI0	NH$/ĮCߗ?Rt=9Yۨi~C2?I279բ%O8۳'ܲ]I_j"/W|Z.WMuPYns42wznóZɃơ
<sEFFI}A*ȑ@1KAJ̪$Y24PS
S55EPDh$Y
$`BF`@ef::J+$AHRC
MTOƨcU%ISDE30DM&t`KHTM$MKET4DS)
L$UJK1Ī*	2"2CQL9~T@IDP,$,
x~=yNpu4m֛r	x
8~'RCU/ZԦ?S+PeM43
ŨّeNak^^U:	"v&aU`%s#Xcm12̛N7ؑ%4F5FR.Ԃ"A0x!yp~2B',~l|sT$"	\H0D?J(0
QT^=kHdq#n	d)"TPIDK3l2a"
()"Rf
( I$
&X	*
(bj"j)(}EAAK@BAK5,<U
(`EHE4P}ظTAMPPLK15
0!;MMș`)
B(f(B(ffBJIeb^3DSMt? Rq9MUUDTII-PD1	U2@LQIBHA11Ҵ5M$Q,h&Y#*h`RhJf*	h@i"hj)ZEIJf)Z`>o-<C>χZӊ?TLsX?͓ȩ6 C^[)!1t2I"U'!\LLMG,U{qfhjoUL:b111fe{i])fqA6zmlA6
wD7y<!#-hXµ/ظVZ'R
ei4b8C9{
5e6[+{sPBa[:vkfs)/ՂVN/BI\}5MGtL:~s27af<2Z22aL£:M|Tyݙ4;
.EZ<3EFq\AYc+ޤqr¤&)ڈu26xo}f%/WY;6VYHTuWǩ!fq7+m?$9e1l	l Q1Fm{.2(7[s	$,})2ղm'	ӦXcDkU*C*l#3Aa?5,T!
+X20WX(ht)Xbӈ;N5ؒB7
 *ByTjÃF}|3bC3XC۳4PAIBdtu׍pMQf1A-Tm&3:9qpN΃ .5fCS,HMgFS
BƮv:.goƸ:ᖸv=ؘUը:zRӮTAu4.{1
q00d2/MNCӵ9ד)lgՉS$tN=wGjT,Nud9(d <a\4DA #{4
4Ώ- _NElx̽9lӛzci׊jju!"ֳ'	JֳTHl|aft#¤r ((
Ɗ AE
%Nv{dws*TP5a-h1Zh5IHMaQir8ܛ9GQFg[s̓pZ
j\
C+.60&H;Ysx8xf#EsH:)t57˳gkSq"8I
wI/˜]eC)[?nWz	<"F0̒?$:<7:!tn7k.V֗?Gnl*tخYO~Z0թO}%uMC˳$?[E!95	"cDL)׉pyųq(/6`cn50;HM4u7oߎ!cA!w2&7ƪ fk0!H5QUEg<Cyi3}s𡩖@U2+ub'oSǃ\vnuбzxf8LgS\I0rNP|rsv׶3M	AQ+yQDRD%@PX'@$?~b=6=9+,ְG&&s	RSz&`H}|HK'dc	WȦқ+|IYZqAMxB_jo ]u5vSbaE:9+;2ȥ7n`5
,y;Bedy3--KV
Sw;RkK%I!grdL#bsgǝ&1׸cM_I=4kIWڤn^\Gp&Kq*;_{gvfv/8<|l{8>:Zf'=.zg8~=gULV)+mkz$~of#6m)kmҗO'GcnOmfUW&jUVkVUUQUUU2f/F3YTOSS *)Na5ĤDbuX3H3']3Vͤ)*7Z~TO&ȹ.<zuퟯzΛ1Rm\Gs>G	M' % ss_}э$AP=]XS^92fjXesB(9ԈeTfc¨q;)K9swqCO:vOP`zr:`Z?<
&ou=
o샟&-%1|V]_ur վV3J9jN 4S/ᇂcY+IN呫X/\Kό 8| ȾhU.N7D#x7Re1V~̱lrN^y/{Y	o͊iۙ-r}jo@ϋ(.R=&)G2tl74ڈ$v'hD-SVHVTQ+`,K\Jz`k1I[Tlbu& qr%AHY'G_?sfPs;6c{8S?y;=[MV5((K偊sgCf
?=hm;M1S[J&t$MƘOz4(&W#L,$(@		mV8yHjyW~&\]JTLJͯo;J#V/|xem#4~3!p]+I ːш˿<@jN/[5hT
ڃrBc':믪ڎpô	uHs>2#/Zns'O!!pDBM@`J!tI:bM ` Dd1'=Kޝ&5 <_TG̖_/xtXio{s|"BJcJ*mm'qJwoS\$sԺDR0<Æ/&Ssp112KsuObXlx4*} ?0,>Z(7.t4aX-A0߲ރq8hLy]4)MUJkѪ]\ex^M
+o8!A6yw?NC"{2ftͮw
d@~?F(ǖϨ`&?I3MI>wv/{\l3-ӜI{s^=Ci]c0T48w1ϧ62ѳh~N6OEGRFn:~.L7woj(
auԐ-}G"ˁlYR:rm`VdƤɈq+]Sc$#ẑ7\FO"[t+r㚷~cqBO̵6yd̛
=+C}R'1?<9.y[QY~>ɕjf12Jٻ|S~1 !ŧȎGHcGWG+3E30'ELmK@
U)˓3{uFF(!!H.wT2R_No`ft&@7Dڇ
~+"`VhQ.HN~5w3omEf7ifu.PO"6rj|uKŘڷhNgô,:Ke$DVz=K-{hU3,\Yݖr rɇaxb^0JWr7!_	Set<cUwkYGr:F]DwU5scoUYt1z6|ȰA/.
!9f.@K':
D!8sdnaa:
O{ayIP8wo}._sj2Ja[0zz'N:ԂYI^ Fp^1Lᜆ9M1c|9"PN>IDy|.mF(D$\\nxyUQQf'S>ٍ:Cte8[
XT'6r\kR,M|4ZFbH@d	 H.vf';-cYU=۶"l̄!,|8CI m'B}?!̦&	:t\" 5ADPD|q`DTxw3<32d37Y"$Pa·qF
BN3엮ʛ9 XB~dASg}?GGd̟G{l% aLX	
B/
$ ܄CrBL0/aӶd;UDИ=UGn|B侠7Ymzzxp_i(0ct1$#&~>Pb<'5/<ltzbQRɔ5C6cf-EFtuX2IɑG1ۉTtQE2sHH!!*
L2VVI4+և4L\}
9T+q:Fc\10i``?\ Ot2[OɬlF1_2/;:&|c ? 
8,d4姷vM{'uZ"Pi>.wFJ
2G<J+qh6.
8q]"~6È_pB)Y*!	ϯɻl2CŁBHxE4ԪbRU
>S=
_5$[nF;8^A&Om{s .׏s^a'YKq3ݘ{-cDwIY8'Ki.>A4aP``' fiSΌYFF\Ivscl$B"F	9z"iLזxUDelQÜ/F9	X^f-~$ET&FD22b#D8IF	a`e?7eO#E,4瘯)A{^	ٿ91tcs4viYvmѽC!J9F~\eGk
5^6048Ļ%?[>_\GD>ς|0^FU!HEa_{sɀCA(B!2J(0v(D/`QăZ%n4mǻ(HRqWDrS؉!fQEfa~~aug^*HB1ǪG@.'Ȧ.K_ɭNbq쌄[	$q ,tcif
 zBG5Q#klG |L\3\C,F_q|SJ.\iY38?zx̱("PPԀЀ}@
 [{
8t͌Hoc?!Q`l(
Jܺh[7P`p,e9RR	]EYq9\\FM|I&/io2F3B]iLpލYn=E
α	{PYv<4xG; Cam#Ir{vl13/K؃85#?52
A[M~`<H:vFa1%.2L	/쥽x8P[y8:f	<tvܝL:>#q0bc33unYS3]Ni<!Վ`ɺݳFa,Q>, lġ`Ђc1#/cymq!2ͼk!BDapughy:&wDD!	x^ϫSSg~RN
>hN}g a>qV~aWs˦x$x%
)LI>4ք9盾?UJ_{C'6ޑ3	0&?cH%h~,]6ny !v980r=|o뮊\6~.>q"gĝ2)}wޓ|9z|4_T@*[Vqr QBBthAcŀܢWs@-8'*4% .~V}JBqßàBZK**J0gk$K,p=(OS憚HpL&G0HP#%1N>gؠ< yB IBBd,Bzl0Ǯ@[.w}8|i.F]u(A? 01=&8WjS`@)B#+Ml`|z?0o	13M	HAQL%b3	TE{7Z5Q pDPD $}u~2ef(2XdLE]B==2aa|\ 5 @wVE߅Z.s:Mme}R1\{"~ZHqx>O/d"0C*PLHIh&92֢Y46T"_1%e~!`knGNe^A.1G0$?vHAWd[7">4&pwI&mp|[\&{1d}3"Ł#8{3y%CnJcxq&f389s`bU=GGp&z4@IiC}yMRy8εzђ'ߎnf?LṊz)ދF H-K1h2!ȷ
]׹{(FqO2&{VS(&b9FP\-l]+bBI}6;TTߺy
q%D VnǨAy:à"z`1T"T']w:>bəh`iGcQ].?̼4 Lxz}G;A\-LB?j&FHEDtfi"!^0Q!"Z:;=,Ō$b;oܺ/$dh @wu7>EKB7f)⪇" spD>`
DɃfl/#<.<oa݄y&9	3E{Q\LhWNIA1V\oD¶.q87Z9Q7O;gr)c^y55L?d`2lD<ne]:gљwb;޹ĽBjܴߍc}I%N-(jxD67)U>hFi[իTع,o{ykʀk 8l{jZeo5*|m-c?";>cv%20r&d	vMm6@U~;w;?mM7t=\<x#>"zM}ub+ϘO]Ue3
#:$]lYN@a:nܭTJb%o;6Y꽒'<##4y?O'/,<OG&V-jJ
KA[n4bu4L_^S<L$?}-yh׷fZ)t>l8oj5=ƈf[z(;;q6j9c=z>Va|	8n-G%1.#MNzufk s0c+?ڊF02VC).[\ӛGL'wG4xQt<}	mQ(4Vcۮꚹ+~=D@BM$Dlu,Q5dFe!:LcĐ!
PV16ϩchK< ݒG)̅ճ~M\x'1BlVɶnzC~c'tj˦긥ݔzf`pɉf(ӟM{jCi9EMp#xr8na#Yh%I)v"x{u+7G*7fNq724ns>x@΃Y*w.3있$)!̮%WV7=YB˼lXdJj519	 ѤOҴr_0Z2@vLw,TG2˞1JN]8;fMH4tPI_jlGW$T;A@xzAfUVoͶ;Ť}D׎Mg7"cr}m9~/o'%t6Qd$QKs߾BSJ^
xe=f
W,2Ljua-qe5ҵeT&C<z
1A%O
Jꉺ!Uxх&&RSXÞ3خ/v[Nd?f
ѕbg{y~{wr2t=ja6喋ܕzi;Cˣz4;wFX#U<,e	zRnii:a̋5W(_kG6S"dk|O$Xvy-wzhNpO?/w`Am;b},cH؉w
ohyfPJ   
RXi),J4L!}&*MB=@{at>-
)S,3p>H b:%6@aQsL4p|m?\CD+
5k@؝v&o*?)mEy1Fq^f{AMmWmYx۲ɖ갮,7BdK{ Дki3<,Mi#+o?a~b[,CAŠ(&21y&+$7e=|_}>;lm& 9AJ| a+}Oi(U{E̗0x8)z$Ӻd]yI;
8$~GMT'1к
ט$т8YC$(^	cr`7v\rDbFHv~,tyˋ6/տr
SMSŶUtT	CE,-	W"UZp@Wq	aAllh#f]Nu+c&	pM@ \8D";%mfrgtlÂ&$Zo+;ʚ#8b-'27HѻP<ztC	E~Fg4?$L$0ؙsq`CK{xƔN.\y}vhy~Mj{t>\
Vao-~%F(h8L*{	:!Ol]^hy4%
πw<b-3\OɯN*Ccnzj>nrT1	Ch#g)ot5@%[ÜJT2i\!mC]LCEQ
	8*>r!BQ6Fqb	TN$H$ Fkb4htPa .A#83ѡQK( }kS daU^tL
xlnfc&D;93--e>҆b">'<otcOEg9|"b<$SFP%'\@a##Ž
:C@$Gh!.@`2EKwВJ**'9^LמsLN!lBQ}u~d߳`VɝXeT5Ԋ8Ѱ*D7B(6%(ټ whkFXQ4QȴQMQT|p=!oI~vߡ߿ocچ[ɏ
C"G38LC,Im"Z58DN"(*銈hiZևNOMG؇^}"(
XdÙ~n  aU$U0A(H
Ghݦ!P _-lig
ƛG*6HWz=mIjPDI~Lcq/L@:hd	37|ޚ%Quj!QG|}G.. Νoz7)@3_K] D@@B
xE:y0;LIWK`ncl1	cnP(diD݁>GɷN$TrʧiZk7G#9ۖۦ*EdO,}Sb,װ&b$`fފ?Scbq+)]:Yy#FZӏ]gs+;?߇kRǌ[&F.d;_mSK1f8!fcnI
F!k;x$D7ǅ;2Imoh5lْ`Mt.9B3
?/3ϦeO?J<m_y&@k=ěF=c6l)B{?re%8RPPX12
Q!WS|7]O|Op(Pq3 ՖhX c/=WRZk][q.$Qv7]/[Ėnv)ltG+?dLw7BFζSϑtOTه2.N2Rh4@- CxC?@~D^FD|XE	9deeut)^kHBi10oFhfIUUgBTBSUUUUUUESU$dC~hSRK@bOl5$2!e˧wD8m%?x$?^/c,)c_4c49=ҥ_W>la4w"-A^̄jȱ\Z38ybgRUa5]v<k:hWX[Ҳ%~	d }Pq}<Wx9x
| La̈	֐Ad`PH
uئ KBE2; q!	=^A2`,%9huXv>^*kn}s#FCpvLILnɇ>	3I oȍ
Z
 8VhnX
Z+mBh{I$%)]ȌVLu!ՃNb4`s1S03fۭϢCbZ,C%)ef%8;F٣cn8#^ e!.e93zEǶɰ?9|BЇ]Z6O`K&Tg1/e^^}">O="2	3Ɍ16D2=첆FAZG8Iz ^ Z21w[Fu+Zu ,
_`-~Fbmd~Q0``Ч(u{ tA+f.39[ox';:
S

kǐ
~+<|^qSy 0		h`"~5HVr^Vic"߁iϷ@EW&#S$NH$goQǜfR2w<3! }4hczEv2;AhSx{8rGzΨr	`]G2|^3/^knaY'	oGdT\@&}3Fu~>ABqe`4w/--]HI/2.
j#Εu=[wÑAM Þ6 vd3Sq }<wrpJj(-pQG	VNI%Tcqȿ8\I.GZAo#$YX(ۻ> V;xa9%9&nT"GtP`f Cx0ڴUڼUk~o#Z|+;
p(Mr<~\8M;*Q~瀭iW,hmm0;5rfŁz8c[-nۿ|rr{9`5u8 S,HNn䘽2HLiK@.P@gsSgn 7b',}BqC<ͩu.6\!׹h8q`(4hLa.3\=ڹ3}>*dv[w8CQ2nNi@_5=T%'o'7$͵݁/7<"$>|61ՅvL
O!^1Ѳau2;Ocuy

?dЩUn7)k~p^%;I3uX.yM_`$;鹔?18*h9D%nQlx؀TZ
n惰[ȁt:{Qrc13a6;{S9b`Qz{ݒE>nJon(%8mFv=@N)@nAd@oFk\O'eAj0KVN̥uv+i^Þ5Z/Sґ9c#_ӧN9i˒;:i*zaZhbܞ/i#OG'Td&7_'f-wGzC4+
)*\׵1k?9kͰ_lZ-=\&}O/T3ͽlˢhBgdzàw<AmJXMi0tQ4qYg+d"5{^O!C}So;[:?IK_1	LYv4h]4B=Y6AԦmJ,̄xMz$*!*o.e]c*	t]Bӳ!=BpSI23,3*\
_-7wMs_');=YvM{|Q^kluԳ
r3Gz3/6t#"mzjQ^wPz jt9UP<PIpF:!쎸7pYGSO+z:̣^l<+
uP*%9vŚ ߿Bh
sY׫vid˓?.h7^o`ޘgzb5R=xf_?+#HoZ[ kF޹&áxvhȊfA=Om0ɇuіH?Sҳ:ifw3	Z#1_&݇	3evU+<#UCTZX$xů!|BuwCo!XQr$dƱsubc8,Ol}b?v6 op5nR5>-sM`ִb~I"		?a|
2	$m,~8ըǏ5_
MChTơz|n~PI#jz݄LA&la+ՔaI!MtţG˦kh)
G.pߖ*^"u݌ %D]]N/4Oj)O,wj"SOMTs7ULy# &Cte]3iđrLmi$ҼgѮMdKHq#؏>UDc˟_V'sͶE	͂Lj?pTH"^J7f?Y :+{//WQa>  >L@4S;3rg(T
V_FI.naQ2:f37"#Bbg1A[A37~u\Jg@[I_.21oLOsǥp2Ҟ&ס'!7ļiHH./PSPe{r>˚V^p{ズ~@鏬|
L>q60xz̗.|a@'"_|a'.Y˰C9w(!Ui!"+rǛrf`:a?_'qu:z{(oMP<X8<
'l;I]4Q-A4@0t:Fb=nU {
CDI.<J_{m2;4*P՜tqfNM4f\5+AY*oB{xa0Blc`˟Im$Hl̊Xݳyڊ*HA3f˘m1Olc0	
2'Yk$f'\(L\թM(2EMDvN^$dE*6*3>Qt"69Hs$Hfɸ?Iko?_ՕCP+TF,
xDK0\2P	 QP

LiWMG;%Ig6ot펠.^1Zsb\w<~'\\9##KgsNߨ^!:-7pE8
`=]s3@tm-PTyPf~d#⁩*@c`1)C$Bbf0òQ"ehPj+
	J(շ2"\D:3 0jj=$APV~C'(]B-@IBPْ=%#E!+}rhex)3940cu˥|W
O;vD4AВ.B='	 ڧUIń)|{)tԆjC3	cAd/Sy\\ЇT`B~&ǁ)KhNbsce^Bɕߝ]ߺdvPǋ
Eວf[X\jnIY!OJ$7$iH]$9ռh+ݥ_JQϝamXn3Q!68IʀFlD40!҂p(-c7/>;pпiA}X4@O*.eVŚp#' [o?6) ɅBg1, .$QQ`GZ"gŤ2
9^TL-
&2w5t
ٛhRŀxB$ d{O||/QnH>BaW[oޣ<ж
{lX$YhP혴f()$$g`\B{c[4S")O/WZr,^Y:\ICã@S@q0	6=	 oKE+j 949aQsV#qBl,,JȹD~
gw"F1LgMvpԮLy}L@?1S~[OCK"A`08poJ)D Ө̾EHD]`7ȠaLR@3T	cN ,/g?0a2EJQ˘`Vr<@y3*  D\2L7 XGzby#3[lkL^t`yAy'^qg
bRgbQB
An&h=8Qj0̍Kp0 `J@F$< 0_SfNG,Oildj
)`bާ#	Q)F"<q.D@@½W!Tȁ`dU#T>AޅR1	[3&<za0Be]38}r>ok3\^8ށZOCP@=PX׉"DKeXJd a"p,G =GQ69<}ݹ57yFp%3*b
p2:gt"yP}DoDq6567TB}QD<Z=gё흷3:;=u<{b':ThdFqk	/蔋,0$U	I;(Q,+T_{(7>H#0rA)l$цP5{0y*,!`.
H;!bdXdIXz~RvfyӌD)Pc>\ ŮN Ab"+&]Arh%{l&Yk7ٛHH_ѦhcM5C?[e=zyV?
:H`Y@"AZGq	?Aڌmx<0<44``
\P`NA ҭ!2!,! qسX92%#aS4-ل9}p8Po*bl7sp˚N+bڢPF
)+@~]'z\!!r!auc6Kc3fpr8 wO
N!-N|t PSh(q^Ix/~:yS٩wn#RP2q=oKBpkHt<EQ
9d
D! /3ƒ@M0ϯ㩹,31Dx[CD4àUqQlVs<o`:YVu v.8=
.lmqb:z|C
87vfM$0qGd6l8bz eR
nFYOq"Zҍȷ{r0yR!x%V	À. [ܙI- c{7=>M0ǭ@PPRP+BDB:i[<m;Lr:pm&tNi@@TE0L4g4:}C<uQ!2CTElc0<
L\e*Q*7d 1aZEhWm
0H (b(*IE<"b'rRD;o8k7,PBTP9(Ԉ;+=(aF`.*Rm<bsdlMizض =̴opSp 
#iᮨN̘*9F_DQ-VɳASV0uS)`Xd#jcNz]3 $T,D(
DiLS^ƚs
zH_(@~B{hG'
8s/DM"J`D"ߕ@ {nbln,ohG~s[75af#
`,XVFID4?
gwy&Yu2K&/걚EeNնӍ`<>]HۘD3
,gy)-BD2o$d-\;ir̵|3VUl7KM8mP}?z5޹ʇe\jz3!Z/k!SADQ|tB|\Y?]\Y9_~swIg(rgǶM#36x[L;-UU-TDEP%T%
VGPgRcag4&y4'' АĚN@:rz2hxl{(@rP$MQ0^A̭ wF7YsƐ %*CTUM@]@
qBL<:=NRQLp~8x"
Rb*f***bćr**>lLqe{j Q0JH9rȖp` v&J3>uM"D3Щ)NoצCGVYFrX6.H<*d07!ʽ圬PAD	&nC8
99˖!ƃAI(?W.5cfu+?GWqFucA>Ѝ~#x'v*IA礘SSPTT"	#2?
</7l-*:bd:8D`"f+c,%1gbC2 9&

owi~?ɞBlp
x&IRJc`Y;BQыG²_B;Wм|Sr_268$g"5sq[:
"G@ݢ	 PUT%&
ih6``ñ+AfrFȭ'>'kz"~)J`		T'934bcWd+)JvffMx|c
6!YvBT
Ͱ@
᪜Kr9uhkw=1û$9X6E䝼ǧE1
sE(C^Tu ҋTfJX"6RD^Wֹ72vݚkBBHB2/hnssVsSЧYD]\&Y:@޶7ՖF71yt;[gEU
$k+>؉
OS5G`"XTE< u':9"dEG""j!yF}FdPҖ4PCʯA}()Ǜ`iŦ#> 0"rU!@y@0!. $ =źN)q# b8LCF)5Lp(v8fay_4ܿWBiy)@PJ<Y,`dDZOvȉȊ@
 0 =dz`9::yim@?*@~lg15PR8Q+"DQ	BSP2H2!
Xc j]G0gƐӺɝ^D_p؍ @8B$<`᩼]Cg0T9aEEXC~6
G9Q"h@~CaB"A%z	8ҟ !֍A7 ִ}$_O=7"@탔K+$	F_k'c<ih?қn'^  Rc:N M[4-
tA
O k[Ɍ^ha&!Cr8 Do>[oL̷~Il7ƃ3P+YІXkh<dTUg2rt#
Bh!>ցTMg4{!BJ\3qC4Ð$ \bECE*/<^5\o&	JxEGvSQ|9?]T rk5mO̳.&UR(C6V)&`6BoCq  BFD z,Si@0xCse	!:EtMizK@cIc5 ETTf!"jLÜ`>H4鯇R!@00Џ#Zl׺|jJE(1ޛKU8Úwc[&bU1ԀK[
zZ"=I$	 sri+FL84yފ#qZ|H}ۍ^a5s⛖iH8 /g-9ChYڭVFc1ISDŖ^ ~9Y)(4̓:=C!J2+HT}9s'SFą M26Ἳ[{{A6eCàh26irq-RT&leEa0aj@tA1 
t*+ !95&η{1	/O_h`.G<۪ś!6DL2͟Z3fvvd4`
lY7bh@
&PfmIDb\#tU0*1$.웁)[)45.ފy(_k=@gy|(kCk
!w;5jҹ0yz 2Haq'1j~m|0ǲ?dXG.X2ƈ
D+ 0
b9z [aؠQWMk DOZy=ia	
fKF.DS5*
"@@Y!$W#MS
=A+S58!ʈ"tKgUN'PDa%KnrE$dE3
Jk0U;:oÜ>qlCID`i;1P| %`ǺkzRTT>Qy(RWx}i	n1fr㱋ۜII4H!gCHtMs$P3	U1ΐe		w;kxt8*(c`tcAM14QEQ@H$ f)FuˣxV,,+W\ds\ݍ_GRkV܌ܴtl bD0.||E0gy͘q^DD3E45,ȼ͊/v$9
)Bhd@Q:{,fL"Ў[O%e2t`DK!<!с.VtsqdeU	60
5].R=m7$tA͚c@	$fn,V\DѯGeY;sKHZ:Osyiw8SwlJcPdbi8
ƢXRkKmDӇٹLlu%BaWëNvNvZuHae͌4Bp.LQp6vKS
6 #L,O#15 EO"O8,x}AT^f>5(HkesR3EsNPEUbvӶVq{ZbxnM3lq&Ђ=!$}D9DH zpSBo{Eb"q: >
$zS	΂sb%!7L9"I9B͆GAp`e"6S=
1R=KI#/5N40Q"Rt
nӸwmC!4A}d`=k.}]2̽O!;Z0ԑUwAMwŎZbHBE1iْYݸ#٧+hFځBv#@T!!9 p}^k&\Yʉarw'@d{.9^au 턄$=#_b!JUe<?X0SAXA֌H(X)r&:y"e
Ɉ1$(JJG*=&3ٌQG(D*aB `& 6]%"*=G1!yP(rAT=X1KqyA\"#C쁖"0fC>-
C&KISDMi4@Hhs64ANX4@F34CcuFg`Ze8uDkO7iRP6,21ho>b܈/k*5!E@)8YɴK@|RMpШFG$$	9_5z'0~dOB0zSj1
hM@d?]8]xLr=
ZHa@=tk:ru߈GS4&XnӃ7(_G3C0Cр?<LNCdU<BhI.&7:cXj5EIIPGk{tDᐉT~$K20^R.wVu@ӱu*aHQq@R ! Etd|uH6$F
Kd?J/T?9Xb^ђ!(Foc!hXG=$#3(nr7Bz%ZR4Mz!X:C3FDg8]\x
6>mXH!
!U%He$I D./TNZQtxy/{p$$	=_O$$8@J P3[Sv'@@4
+HD2" Pp404`F I I^,r {!f iqF|CrhEz Y+= ~N|ywJgv],F
O+>	 g~	<
Ns,5G=p*x/mjVR
"&0LTco7kJY!dLⱉ 	sG$2Z "F!ȯZVQ g9&o,/P6y<fz(.edGm&PYav!-XW6:1.0ӄahM&4Dg1X04Ĥ@JN0" zIpоF37;'z]?r$()umnQ,ÀnҚ Iig1P8Ғ3PE>@ᑌjVG.M
׷a6>0:N=,\aWl0\L1ĘkD^ 8i0&b<<{HU:o3SG;޵4J7#2QBTJ7c2Ӥ'L0̄x|X~kC{G~Hd4e
P(_BB11py?/^}un%5w#eD(Py`ji.*Is 
@ӂ)R*:Yš8xܸ<A>&ۇ[mUETnBTdDIw{EJ񍥘G@5`Z5@a1L $ 25nP
ɉocg
h`GZnDA&1CwэpJoO؊LrB1
\NV6D
^Wk|%T$@F1j)I˖^v
b h9N/⍃B2SĤ/1p6ܯ1nZ	ˍNy=C<SC!Dq'I(O{o"N1 򻞐8֓OxsHi[A(>nzw԰0$G)?EXZ.=Q}SHDI%VO"|u/pGH|t8+* d99|9 Т:v+o'ݛ
[PyRL`=z;c`TASCd<JG4.7\8.	6pbXddQIVd=/<wY0^!T-2@8MLS"{t:C4M9S9PԱ@{a
a&^e
DED=W'{[m냉T>L h5=)<-G,d ;y*#3PDa`2Edc9Ju& dJQ(iCk>v3QjJ2<03Mƈ28O hPKjg@7](r}.djB@I0BEkpP匈jOٽ`gt(BBkKVwH@bP
fijDAcD+HO`ЁDK˪ՍjD54aD@lFNEXF#s"RT}E73G7С</pܑ%5fbD* E1SRJ$,@EILww0zi1(sͿpGSAASw&.C ᇣFQZ-RPX"*Z#eB[Of8۷y+;h(;ԁ2w;y	gQa.Ksq9&P_bFGs䴌>b\ub#4()B`m"!;%!jуј246	0y|I)&+ 9L-+ځq9Q7M7:<?>Cg B]f @3j(kz% cw4,|]$dʨD(s}FB͂94L"zn@ 0x`Jbd㎪0w~)\y).>GO,=6rX$3EQhORxy#9 uR<-ya#HtE#R"{<t|MO:\=?/O26&B	aD:0}͎Z̶@LyPt?=׃B}sY&ZB)"jH%8:<Y6>3p=fL @d*H!")`bs|=";įt9(fd;ʃu|qP`*^'R/D?-	QOѭ{TE'"ߓ
}^=Fn~*sf%?M^ÙQԓPL}bSvv&}K$4m	ڠ=lAP|7m8|5xDN(֭396
pԊ@%:	 b£ ,B(FHx|wè..#,nwѿғHk- `<R:I>Bb4aSh=h|'+6h
~B"Ay얼39_c˿бUa!q'2[57Pcv* 9Ǥ!Q+
pݤpKIY9;#oY95vR)V10VSM"xJKRj50޷֑&BDyκ FC-j"y[PqWk
7SQDZTl*̦ӪCd w.m;lfEblUG6p]iA`wHi&zG憎'=OeCÂ&, Ad
i4
,G!2fShP?i<<HZlh=hUn#3xs$ R9A
:qd126(M6%Vi4AfaJ" 4I
T^MA9&V8lKL%T	GBuV!$
@HӶ%ł9eچDxX\-C	WgmގԎ:eZ:*..-'{t	a&aO,j7bz_-ӫ:bYD[qhȀ'El'LAbpE@1?&qw+;+bl( 0S+`&aIIe!Cy{a"vSy4)A=,CѾ'hBi !BAB͔sM5˩Wbc&c[m&Ub'b(`3q(!|YmY.`m43A5.x mLM@u`YC`2q=S!H:Pl
"4]Xi]Z[vd" PcoJUb_>` i5@g$Sh~IH#@g5P*("	Rrxt~M\z9@Mhw
2
G A,}/>MA@C(M(4A	*DA("T2@D$ #) ~ڹOG:=LN@12/p qG?8clc'oY?יHъ緉%i38;+/"Sp_2N0چliM8cs3CaZЁcd}@Å/vю}N:WXՍm:]l`hEHI#dBD%	kiKt#ޡd]ugo<ovXA@AƆP^߼˱3xH+W}+}ٌ!"$T'rᢶˡNϕh!U"XʈAnEa=BDJቬN}:{)7"_MFUݧXf%cYHm/q+ب뀉J T=fbԐ'D
	D0a~S^KVx0yxNc!.CKl.0\0g[r&2+uoN΢TQ`/Vaq\66nn:C^V`'qBYH
}dx݀B$5["PtmiNNm~=H6"eC~'1|pt~ 2x	j
r3+|=~0{BK#6"='Rq ȝPؕ~
It #8XA̴	#z$mnK#MfǍ,OiTq-VL2E')(*>SA9jo
H|8?p)4a;!$h2
*	j[l[8(@	.,m˷ƶtCL\ {치D9
@#6{em;'G!&?3KC
<Gs))\F bW]ԕ@ȝq9Z-dGmM8*`,cm
(Z\W8n7:Z\e"6	@&&Y.<@[r˕80\T!táx&gF X1L=gHJ6MzvZp.1
50͢F|S,fB 
8iy8VMq&ၱ	բ x]SC	Må&[
LX\sBC,36edfwfh4`_0Hlb7ɠ$R&!<W]ӬZGNmr
8`mc*XW9,b+Zh XpNØP4C$AZAAF XU"L,Taĺq#h毵l.2^0#eva!FRuh0y?hكi;l0QWoQf<+3Q6F	rwiQT$چBʣRpzňK6XUo4l!A	Bd,H#DTb&"i4$@@0HJ fK*CI2	0C
Y)6*tR `A**wNa+k@l۲\难 t>!
PkVF65]qu1la˶0ykJc,Ƅmfa(
1%-pGp1a
2D42  sG\0*. 6X)$Բ&!D N~8"wZ"zgVeI0b,7r9#bBh'璓d?-m5PJ	J09E,2@{]#Y= ecy<kҫC*R>La,Peijd18:ӼS1 ]gMV_5$ P-.p`"۳ av%}2I9Ov;dl1] k)}#7BG|U Xܡ]O|j`Ԟzq7{{偹[2Ḿ:dFPN w\JAWK|33*!܈;`"n7;kRT5!2°x@Cv2|AѯlHq!(dDBK'qP"4sM7W	k1ԃNGObˡ,'ըS1"k{ɝgQYV
_O|JT^vFzetSg=XA$J6`HP?cϚQgk^;j6$1D
ú:N$w$>ۍ7x_c<qdl
Q^: 
!0Q>~䠠xE":*wƃu.ZcG| x$E^ҢEO}DaM4q4`E/2" ȸ0i"wѣI46PB-ۑ6*:I)*UnEgހhh>İ"@\TM鹯MQDMNIH)	_$2 HZEUyNPSM6uH#QC!(@a
a4G
;<et: &< dah	k:16=I"P1NVG{p jA0Z'a4G&+F,tgp>eHOczD)G~HE//dlCé2ټow1KN'dpHrO1З!A}?pJqB؏wop!6~`HirdVd?T2I0G@>HfN2CqF@)b31BAzȀҡlˉ Bi99vi $N*xt˃c
QkF-#IPP& ,Ɗi";B24Czvd튗?~F4O@'Q5oL>
/hg&b(mAKfT1DfY2TNa$4a8~DG'L:iF 32s\>3B?~B4ࣃo jb)X	bBV"O>
>G-9d.F)RQ&J?@Z$ͦpD@ո:KQD2Br/{&P;+!LG^
]BBD\