#!/bin/sh
# This script was generated using Makeself 2.1.5

CRCsum="2516864120"
MD5="99375faeb5c721783e9e9baec3377685"
TMPROOT=${TMPDIR:=/tmp}

label="Systembase PCI/PCIe device drvier installer"
script="./Install"
scriptargs=""
targetdir="sysbas_mpdrv.v24.0"
filesizes="31889"
keep=y

print_cmd_arg=""
if type printf > /dev/null; then
    print_cmd="printf"
elif test -x /usr/ucb/echo; then
    print_cmd="/usr/ucb/echo"
else
    print_cmd="echo"
fi

unset CDPATH

MS_Printf()
{
    $print_cmd $print_cmd_arg "$1"
}

MS_Progress()
{
    while read a; do
	MS_Printf .
    done
}

MS_diskspace()
{
	(
	if test -d /usr/xpg4/bin; then
		PATH=/usr/xpg4/bin:$PATH
	fi
	df -kP "$1" | tail -1 | awk '{print $4}'
	)
}

MS_dd()
{
    blocks=`expr $3 / 1024`
    bytes=`expr $3 % 1024`
    dd if="$1" ibs=$2 skip=1 obs=1024 conv=sync 2> /dev/null | \
    { test $blocks -gt 0 && dd ibs=1024 obs=1024 count=$blocks ; \
      test $bytes  -gt 0 && dd ibs=1 obs=1024 count=$bytes ; } 2> /dev/null
}

MS_Help()
{
    cat << EOH >&2
Makeself version 2.1.5
 1) Getting help or info about $0 :
  $0 --help   Print this message
  $0 --info   Print embedded info : title, default target directory, embedded script ...
  $0 --lsm    Print embedded lsm entry (or no LSM)
  $0 --list   Print the list of files in the archive
  $0 --check  Checks integrity of the archive
 
 2) Running $0 :
  $0 [options] [--] [additional arguments to embedded script]
  with following options (in that order)
  --confirm             Ask before running embedded script
  --noexec              Do not run embedded script
  --keep                Do not erase target directory after running
			the embedded script
  --nox11               Do not spawn an xterm
  --nochown             Do not give the extracted files to the current user
  --target NewDirectory Extract in NewDirectory
  --tar arg1 [arg2 ...] Access the contents of the archive through the tar command
  --                    Following arguments will be passed to the embedded script
EOH
}

MS_Check()
{
    OLD_PATH="$PATH"
    PATH=${GUESS_MD5_PATH:-"$OLD_PATH:/bin:/usr/bin:/sbin:/usr/local/ssl/bin:/usr/local/bin:/opt/openssl/bin"}
	MD5_ARG=""
    MD5_PATH=`exec <&- 2>&-; which md5sum || type md5sum`
    test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which md5 || type md5`
	test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which digest || type digest`
    PATH="$OLD_PATH"

    MS_Printf "Verifying archive integrity..."
    offset=`head -n 402 "$1" | wc -c | tr -d " "`
    verb=$2
    i=1
    for s in $filesizes
    do
		crc=`echo $CRCsum | cut -d" " -f$i`
		if test -x "$MD5_PATH"; then
			if test `basename $MD5_PATH` = digest; then
				MD5_ARG="-a md5"
			fi
			md5=`echo $MD5 | cut -d" " -f$i`
			if test $md5 = "00000000000000000000000000000000"; then
				test x$verb = xy && echo " $1 does not contain an embedded MD5 checksum." >&2
			else
				md5sum=`MS_dd "$1" $offset $s | eval "$MD5_PATH $MD5_ARG" | cut -b-32`;
				if test "$md5sum" != "$md5"; then
					echo "Error in MD5 checksums: $md5sum is different from $md5" >&2
					exit 2
				else
					test x$verb = xy && MS_Printf " MD5 checksums are OK." >&2
				fi
				crc="0000000000"; verb=n
			fi
		fi
		if test $crc = "0000000000"; then
			test x$verb = xy && echo " $1 does not contain a CRC checksum." >&2
		else
			sum1=`MS_dd "$1" $offset $s | CMD_ENV=xpg4 cksum | awk '{print $1}'`
			if test "$sum1" = "$crc"; then
				test x$verb = xy && MS_Printf " CRC checksums are OK." >&2
			else
				echo "Error in checksums: $sum1 is different from $crc"
				exit 2;
			fi
		fi
		i=`expr $i + 1`
		offset=`expr $offset + $s`
    done
    echo " All good."
}

UnTAR()
{
    tar $1vf - 2>&1 || { echo Extraction failed. > /dev/tty; kill -15 $$; }
}

finish=true
xterm_loop=
nox11=n
copy=none
ownership=y
verbose=n

initargs="$@"

while true
do
    case "$1" in
    -h | --help)
	MS_Help
	exit 0
	;;
    --info)
	echo Identification: "$label"
	echo Target directory: "$targetdir"
	echo Uncompressed size: 224 KB
	echo Compression: bzip2
	echo Date of packaging: Mon May 26 16:37:41 KST 2025
	echo Built with Makeself version 2.1.5 on 
	echo Build command was: "./makeself-2.1.6/makeself.sh \\
    \"--bzip2\" \\
    \"sysbas_mpdrv.v24.0\" \\
    \"sysbas_mpdrv.v24.0.sh\" \\
    \"Systembase PCI/PCIe device drvier installer\" \\
    \"./Install\""
	if test x$script != x; then
	    echo Script run after extraction:
	    echo "    " $script $scriptargs
	fi
	if test x"" = xcopy; then
		echo "Archive will copy itself to a temporary location"
	fi
	if test x"y" = xy; then
	    echo "directory $targetdir is permanent"
	else
	    echo "$targetdir will be removed after extraction"
	fi
	exit 0
	;;
    --dumpconf)
	echo LABEL=\"$label\"
	echo SCRIPT=\"$script\"
	echo SCRIPTARGS=\"$scriptargs\"
	echo archdirname=\"sysbas_mpdrv.v24.0\"
	echo KEEP=y
	echo COMPRESS=bzip2
	echo filesizes=\"$filesizes\"
	echo CRCsum=\"$CRCsum\"
	echo MD5sum=\"$MD5\"
	echo OLDUSIZE=224
	echo OLDSKIP=403
	exit 0
	;;
    --lsm)
cat << EOLSM
No LSM.
EOLSM
	exit 0
	;;
    --list)
	echo Target directory: $targetdir
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | UnTAR t
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
	--tar)
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	arg1="$2"
	shift 2
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | tar "$arg1" - $*
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
    --check)
	MS_Check "$0" y
	exit 0
	;;
    --confirm)
	verbose=y
	shift
	;;
	--noexec)
	script=""
	shift
	;;
    --keep)
	keep=y
	shift
	;;
    --target)
	keep=y
	targetdir=${2:-.}
	shift 2
	;;
    --nox11)
	nox11=y
	shift
	;;
    --nochown)
	ownership=n
	shift
	;;
    --xwin)
	finish="echo Press Return to close this window...; read junk"
	xterm_loop=1
	shift
	;;
    --phase2)
	copy=phase2
	shift
	;;
    --)
	shift
	break ;;
    -*)
	echo Unrecognized flag : "$1" >&2
	MS_Help
	exit 1
	;;
    *)
	break ;;
    esac
done

case "$copy" in
copy)
    tmpdir=$TMPROOT/makeself.$RANDOM.`date +"%y%m%d%H%M%S"`.$$
    mkdir "$tmpdir" || {
	echo "Could not create temporary directory $tmpdir" >&2
	exit 1
    }
    SCRIPT_COPY="$tmpdir/makeself"
    echo "Copying to a temporary location..." >&2
    cp "$0" "$SCRIPT_COPY"
    chmod +x "$SCRIPT_COPY"
    cd "$TMPROOT"
    exec "$SCRIPT_COPY" --phase2 -- $initargs
    ;;
phase2)
    finish="$finish ; rm -rf `dirname $0`"
    ;;
esac

if test "$nox11" = "n"; then
    if tty -s; then                 # Do we have a terminal?
	:
    else
        if test x"$DISPLAY" != x -a x"$xterm_loop" = x; then  # No, but do we have X?
            if xset q > /dev/null 2>&1; then # Check for valid DISPLAY variable
                GUESS_XTERMS="xterm rxvt dtterm eterm Eterm kvt konsole aterm"
                for a in $GUESS_XTERMS; do
                    if type $a >/dev/null 2>&1; then
                        XTERM=$a
                        break
                    fi
                done
                chmod a+x $0 || echo Please add execution rights on $0
                if test `echo "$0" | cut -c1` = "/"; then # Spawn a terminal!
                    exec $XTERM -title "$label" -e "$0" --xwin "$initargs"
                else
                    exec $XTERM -title "$label" -e "./$0" --xwin "$initargs"
                fi
            fi
        fi
    fi
fi

if test "$targetdir" = "."; then
    tmpdir="."
else
    if test "$keep" = y; then
	echo "Creating directory $targetdir" >&2
	tmpdir="$targetdir"
	dashp="-p"
    else
	tmpdir="$TMPROOT/selfgz$$$RANDOM"
	dashp=""
    fi
    mkdir $dashp $tmpdir || {
	echo 'Cannot create target directory' $tmpdir >&2
	echo 'You should try option --target OtherDirectory' >&2
	eval $finish
	exit 1
    }
fi

location="`pwd`"
if test x$SETUP_NOCHECK != x1; then
    MS_Check "$0"
fi
offset=`head -n 402 "$0" | wc -c | tr -d " "`

if test x"$verbose" = xy; then
	MS_Printf "About to extract 224 KB in $tmpdir ... Proceed ? [Y/n] "
	read yn
	if test x"$yn" = xn; then
		eval $finish; exit 1
	fi
fi

MS_Printf "Uncompressing $label"
res=3
if test "$keep" = n; then
    trap 'echo Signal caught, cleaning up >&2; cd $TMPROOT; /bin/rm -rf $tmpdir; eval $finish; exit 15' 1 2 3 15
fi

leftspace=`MS_diskspace $tmpdir`
if test $leftspace -lt 224; then
    echo
    echo "Not enough space left in "`dirname $tmpdir`" ($leftspace KB) to decompress $0 (224 KB)" >&2
    if test "$keep" = n; then
        echo "Consider setting TMPDIR to a directory with more free space."
   fi
    eval $finish; exit 1
fi

for s in $filesizes
do
    if MS_dd "$0" $offset $s | eval "bzip2 -d" | ( cd "$tmpdir"; UnTAR x ) | MS_Progress; then
		if test x"$ownership" = xy; then
			(PATH=/usr/xpg4/bin:$PATH; cd "$tmpdir"; chown -R `id -u` .;  chgrp -R `id -g` .)
		fi
    else
		echo
		echo "Unable to decompress $0" >&2
		eval $finish; exit 1
    fi
    offset=`expr $offset + $s`
done
echo

cd "$tmpdir"
res=0
if test x"$script" != x; then
    if test x"$verbose" = xy; then
		MS_Printf "OK to execute: $script $scriptargs $* ? [Y/n] "
		read yn
		if test x"$yn" = x -o x"$yn" = xy -o x"$yn" = xY; then
			eval $script $scriptargs $*; res=$?;
		fi
    else
		eval $script $scriptargs $*; res=$?
    fi
    if test $res -ne 0; then
		test x"$verbose" = xy && echo "The program '$script' returned an error code ($res)" >&2
    fi
fi
if test "$keep" = n; then
    cd $TMPROOT
    /bin/rm -rf $tmpdir
fi
eval $finish; exit $res
BZh91AY&SYF Qc   )`;x>g ]۸   )2ݶ
[Vvv_}ЬZF．ynog۴
k=WsG}&u>uװ󭾝9L{    |Im/>^:g=}F}wۛ6L}<A}{=>op}}zxzov7nom.+>;޾Ǽa{{y|z[Z;ܩvǣW/3u{լs=yY{FZl{WYz^j:=۬Ao>ݒsz[Y۸nUqwZ펷v6}H]_o{mukoί}9_nt	v^\w^>w;ll|ESH 1 2&b2&(h=#(h 	46%<Ԟ	z=OSL
4ɵ 
 2  	a&L)SƩ)P=FMOS'SOPmPB4&FM=	O)?Rf(44h2L0&L&4&)LCLC@ѠH bfdmziih4?s"a/_͝wp\H->7/|)F6&Rh%G6brw`hCЎ)IÒx,
SH
PPU"Q`3EHI4N#6f1G@d0b42P8MH0A (`
=QAP/CP*
D|% 9 'Hd:$? hOACE+9~IQ(ƛ,KCfxdMwIowV$Hf*?3ϧwɏ6~
Ƴ39o>F޾UeˀJ8f.,2"qy9(lm ŊgphBlЇo}߳!`""?8J2$P2RR*9DV``L%eDT)0&bVB$&&$-`DNpuIRSU4Xji*H")M\hf

?Q&SR4I% SA-3A
CA@S!P}1Ī*LTaS_Ӡ2 (AK{/֛pB!>q=r6rB!QA#!b%) PI_>+6˝M[5yQ_:'r,dMvFG9##Cllcz~F3\a1w;"Zbux-Ĺ;3KbE4K hkyNl\>>h.>\+AYٷ_ƙF[D@G/g܈	F_l<wB"
"]BL*HC4i$wXc,E%2wED:>YN3&*"`FYI* Y$((`&d(Hc%DU-1if;аU
ٔUk0JXi"(?.5%ESE3T4SLEMBzSwbbY90L4QQAHE%TP̅)H1P+UCBĽ#$%hfX +Ͻ)Jv8e%>sDUTEDKS$UQ,RD41LLD*
SIKt
CD<FTE-)ATДT D%!S@*) 	CUEd`A!.Sdf9R)T˩$QL3ӹYx_ hb&e;pLjya\ڼ39e-$ڬfms3߸=DD@D140sFͩ])1fPMae1t|
ƾߪCrg[39."fp2,Ty)*s-@@<
<n,PnaQM`CGqy[X9g4&tR#,،+SHHACcmƷ5-,o[9|uaf;2Z22aIŎ;پNn1fM9BrlloEcc+ޤqraRko{q§цVF;9qf/az:IմB2GXXcmЦ0Uqedi6`PCe6j,نQl䈙kcێa$iU
lVBBu=,mǾ'#m00ky,ov)lOAğnSTfTdGzf3Y0WX6(b/jHdܱl4KZÒJWE.!
fCe$.*`M$X>IcW @Z93ṽ6M 	 D*p}S8cFRz2;cGu'sY9#pZ4iK@deLi͆@&en5$!m4<L9
Xe6}sfLj-p0R b6EGNMQsaS5Pi]'μnE
q00d2}xcn>&E=_gPssD{jp1 MLm%9[gLV{Np3=5@sÌ+"yf5j>Va嶤y[4+k
-(3
Xhb7⚚"/;]a#Pi
+cAb|R adB!4:|ųB9SACՆK mi?kP6iIz¢8؎O.PdCGRECMMQƳ-I`-bkzE5Md.F	#Qst`3yq9
9'hٽQEw)V?@eࠞQ~5߅jSȯ˲QBԠE<GqQCǙUv']^/3^)\+uǏ[˓}ʰZ:Q=5?-g~g=+ښ&>7U	6~epW&oَYM+rT{(uC2]
wӐ<ؾXP	RT6yrm֥"$6 iM60ɘ4{ 2Pb:1l!uUxslUuGͲ`DT	E~ӽ7C
Zl	σ["ΚN;kwcкwÞį4F4[μa煬>]szf#<iG4(D-{M?dɜ&bO$KE$BPE!:$	.s~oWOqߖkHN9q5(SMCM3CPJ.w$>XcsCEu͕ZWqS3x9OJkppFlw
M]^uTю~?yà>)z7xfg8]·F{+0ei2ˡDDYTޕ^pT oWI!Z`18w˥&xT(S)>G8p}4US_7
[s+_D<jjsퟏ>GYS,5벫F{wh֪FZ7d$x>V6fEȪ3V5a3UUnªFeU5Uof-_Ά%eQ=NAN`<\@b8F;Ei:jƠۨ)ޭk% *"=~zV06Gf}nB#R_cimSi tHqᦻe4G	2]T~f>{a}.Te
^T6s49ⷽKFnHbf-MIj7p/ug}OG\cy(4&&s?2ۦy[њ-1vf A;En/Ɔ-v>bf"223Qހ
x
ry<]q=v4rNJΦWw4x$'wtx^hR?2VB[bvKs!iZ
vA<ut;x22vNT(	{<D3k>'As EcV<5LnF2;tu<a-}jPsꁷ!!6(F([<J$.HeZ)~cBUJ;\mss\}.'y)((K40sCo!Dt(q4{ɦ*vIHFI=?-="b=[>fnzu.ma)/Q6!"K{/xWZ	Ƌ*qʄaw3HyD}elՄ#Dӓ4`E/!P[H:cf]n->.F[mHv\sq!v6!1ΩgPɜw39b7Mes8|5\/S&{ 8]"đH}!i*?hz
!j5]:PJKIPM^ϋE0U'B!fm}z}rmmqRx?	>S>7ox#;51{- #
bJR2"v^VfGJ`|`oEGx(آu@2EGXX[y
*lGwui3iEU@pnYb/B%1K0qU{ oeS tz&s%xgM3QD)M)IӔTCICS}?GO\y@߀pMo2ө$8Uo 663\8GdΣO4wأ`ra`gsL[ݚ`6힄$`UMһa(hl1)Cjf4ߎZ?U26pwpi<,
y8τ/6z
Ì`PvYZ#=I.-G08&H;5g2ZI[ϐ񰦱ɐd"~7i6jF72I	06@[󸺂OwMI D߲W&H7ǞV;}*G^3ƫK'(*,"ڔP= I!t`=?oͳff<GCh&jʼV}0˝>c>.T?Kn.K"9E!79
"͑Fᆜ+I*3{5Qa#|tg>UrMmSa0adQm3ZǸ^Y駑dVcHy]b%6
dϖ֖q	69%=ƶZ
WxQݬ"ZТPxh	Us9]3\M I>Q6<n8)|ݤ^vv"XOQ{ D!F7~S>W&m.%|	1ߖsڐLwVmnja$TYED7=[(A]EFwWhvA{qy'Wݩ'BBgC9]ҟts3|jvk 
wO8V?-󼆧,+^JƓwbxFK.Mg᠇/G&Cͅ
?yPn)!%(Le
ۻ4aMB&Ir}sɓry{.*qQkޟ}nJ jٱ:ΆLe8$[
XTa20=]p
[p$.DoGzN! 
qp9粧zhA7aB
 <I#-md*5+}ܾ!fNKQz( #f=#(""tdf I;GfehfoRD(HA:\Щ;%qMKf-D!U_seAU$YڮO{v[ޜI)"#"ň!0"N/TvNHW5)Y5D*wLj&B*ɦ8Ǟ;
e=){r
 P7\*فI*с:'IO12@a.HpDQfQ=bmf2kuTXrH#H)Be1"cmѷ
e^RfaQPUEra,L!>z<ry#jK)h<xH}l?!K!A&e1s[2,6-uJ5TK@z;Jן'OQh)ysR{"ӥ4[FO<~lzd^r~p
֛!\¾eˍt3q[QJIR{R;8XST~C\y}p܇^'BRJUT*9>Y +|Y^2}Mȍs>`BSa-;6s .׏s^A(YKstۘޢ;Wg1(f#qF<;բ|ݢhaz PSXd9GdZdfn'ΞC p8i\b%Fd	nr
o4lgH(3L.om  f@C)I.c#20H"#2q`FBC7MUY B>7!C7T@vg"C[.o|`g7}~|w5HQy
2`yQmbe
`_xHTjY!ӏL-yÓ|>>H<]APll 1#~xq["00q!2J(0t ̭%@1*++$H	laQE	ĄOP'At$Q!ZQZ#R:cÓ$T;HI/KgbBG+'B(w69t$"N9HQPYӔEux$s
ud/^NPe?96"1ˍQTSMuJ.`ifpCࢶ
VeDE]M mJ-	J&?5-RH~ha$:>-?
QzS#zS}JJWl"~kգ6GT:]+☵0h1oY
@Ta{|2AÕs2Ee%mN8A@1yԂ ť"ݚ&l_ߚ)waݶYV&IKƏ:|H\2UJ~EDf$h0[?o5=u쀰ǧ|ݍs,Uߪ\ߑ;&^C>L~RyPPP!ALCf`m7C<ɓy-5Bi!M59f̌*3ǪwZBhB|C	R!"B"ۍ|F6v&cAMY(Q/qu$* IMi86h}=9 >"x
Q9FQI!I9n]j߇p~7^!͢DL*ڐ
pHȤD<ˮ$$7 7S#ΰd/N΋`$2	M#%YM%]./3~.>"n?bt_x0n;
yR)=)Do$o42KWPk<c@
ۗ!JC$N'*oNB`\dZ)ӇN?'BZK**$q"a,c3CM&I2Hg(I<8uvUW)A (!
%
QhX0򍣺D[85x}񭑣9;ܰ06lζU4F8	X) ad>Gx^T{"-#hJD
`Y($%QDۿzq0J+h4aT+*ef(d2("9;߄\`5'R j{rV/q2"po\DPعǡG_73ve~,G4d)BfzP
!@#9[PR7"+@	hG9bckQ
UH2,xO
/|1e~a a*u1$/u7ՠn@avoݺ`|e:='	#Fo%s]tH	$I&U!a<œ<Dr	v\h@<Y٩v4d=J ;G}쒬 S61x|17́'pŦS4bA6T7:&-&,7,왶!E8 r!B.b)%[5b؂~'
ORq	!sN/(	JLƑ$$>EhҡnHBBBI/\Q ]MMѶ<NkĢݒ3|G~XfI";ק =I"xKZjն8Kai^̫ \?YIYTE$	qnXCen6Dё	Ql<(nٌHF00qH$Ŭ$S,qC_F3Sf
FHL s'2x*9)\Ac9Y#tXFP ko]SȽλV
x$="pL!3E{^TiWЦw;56bwtA͛j{?Qy1m] r_=3*(tN󼯢?Ƣ}瀫%k>M}ɴ2}2oe;*F븃~,}/dǟыBjZ@dn$S[kJ{fDњkFR\s,j,=ȯ}`	.t7#겑<q2mju-S|G:oĪM:
&2o\Cva~?m^ox1<b{]Ga:
4zd/F]F7lc,ϟ
^sNͪ5wժhil~x+e}E<׮{tzHU#m*ǌ<;OG'X]1kJQ֓nzq:&/xD&~ny
|!`7mUF||:N1>)ϕ7-4z >rV9{Y%=jTdLjBҭlng69J=4a4u(etz䥹hƬ{<1GL2]L=Ɍ!JxQin@;QFfxcɲ:nٮrE˳=.6C#|$@lx,al!N#cqzLD		#rf'rZ\O1nbnݔܾLj/JcyO.y?˯Ol=~8#8}F_V}Uʜ=@nOvM1:uh^ڟM&iSLS\>xpZa#$|fE*l6q71A`9i%VźЦK`,3ꢨ$QHfNwE>Y^9]Xc\DTJI"z-KF͘uՐ2/˚YOC+_[l]ں0vU4z
,N5OW/!#i:1pg䉲%PY@~|:,ƽҘQN8cwuF-1ڽhÖBnS<5<%+~4:^LWeQ[#9uKbL)˔9v>j	%VαAWJuLa]Ӓ'c)#a*issm:$d1e{L9)WO!mrFcdG'Yvdh!̨ˉ1`y(tї.j*1VM7B_kCf4fW}>g3жJ_2V[z5E.3ĵbF˪8QU=:dy2kRtØ^huĪ5ZiQ#\l=(07K36μԻ23ma+^z)L||μ0(5YX 	(
UZbġIAI) A$/@`^! &(|%o`PJd!́ټ Y$0` ??
r0C jd|
!WVX7G[?ma/x=0Ԝ˴N
F_ȱ}V3ϻm^|/Ձ5,rjx<҆`R[!6$zm6;p-hrC4KA)'t,8\TV1~꬟WIbHovNKo=Ѭи_bonPm0
2`20㉾R.D HEjk2xy'ͼLz[=$p
8Zr$_QKtCMso$(!Q"@0xonI<4wȾߢiOwvϹʈϟlF2v9e_Z!
|ju[uw@4iipQVD	8yrsR],[6]F!.-)qjD|[cY-4'GćLǒ{m%!-ͻ|A32=F
tJ}	У5ëǭ2%{_gWV0z¹1$|EU23E Y'V=ïPv%PN$龐` C ڐCF;_r(Hv;QEIB5cdn뷉?>̎~=)T.6%!~AtA=LSggv02_O~=	ztuiqvW8I Rg__~N*Cc9HYdV< [11hmNRy99ak:E%[ÜJTqȨJr$5;r(:(wK ,em
An6L+ArhN,UA34ʒĂD pbp GaH)AF&&@- ,&$ `"Xf20\
vh@'-SS HxZ[˲v1
z11X?oiCK}{'Zqz}]ΐO(0!1~xӯqUETUDΟ}8b+`F5/k}}S3>_OA"ʊ?3uY6XEF8,x⧫dkrL,D\8 lluDJU5ERIy7S+&ʢ:[ܾY,Mr9"UEu%u䐺ӝ0AHdQ<C

yED~v]4SL~_	"BH2ȁT@AlH&`YQhݦ0pC:#K;M_5i2V2'ű>kno3vk"_^Fc-}C H
ɪ~ITQmA"B "1h~u{u6ID ~%+4H/?L#o	5@@61%z b06
1{YE!QfmH )חoxj/řsq{"6 	rw1um}Sb,Ө&
%"$&h@4vb=*Id2h:0)(5*/}?ӕj׭<gw1@I5,
2rD:ZM%):<c0=z͵-aQv\ǠYH6|WAi!9wS3$-vM2j)<y	
HGWg\?g2DN*}THo!^R!Jk<feze%,)J
{"|pH.a!f5+%^rg?[B8Mz~.<o ecHO( Bu*Yg5A:1^zg8g$(/\GZ'L"Mr7d hvYH}
$:Wu2V8cbNYAY]\g5Iތфm>]HT1@SUUQUUUQTE4ci?%6s9f&GHg-H2l no9753I?brfpYͬ3S5
/zxE^a(,ِ֨^E-byIs;=(xhQTmUp)XI*'|vUﭢ
 DX\j74vߩ ̟Fh#݇*	r
B>rm]QnI8Q4捈HCgqt
HC٧`n,%uDz],il<A=0QFCφ7?lQԒSC赛6lg5p\RHy!D*-RbGv9TVY<hmI&IF܉j}^XD;+9ŚKUm`C=Hm}{v.h&l<h|{x1yJGP (3]\Xgbk0<`p>H6 lmt9g,&r2A&d
(a#]t6R
L4gF/`=6K]?K
<-@u*Ax&](%SًrvmYr\3"ԬL{ڳAZDGϮ#GBPRvfoDŜn{{w-c16;)_}fOB#=cϠc"'`eL
t0ց,⺩ӧ2D61Aa`j4Nћs(=7TGքnRL1)yP$1}m
Go)Q޴)qylИN&`	|(fR:E]Pj/Bn!GI2bI$B
#(YURA%>v3[m|F~!XuC]&b~R$Lw1óQRA&4yݪ";y(>+S$\r6`AQ4w*q\+^'A'9Df~
˜Ii!+D=Z,ߘ+/M:ȵAA+	pdtsRЀEF
 . eױb%L1V^G'A )JysR/"$86}.gCDb/my)ϏmYmw{SqQD˻5Y7_zR`jKC~O'9U[&o9n9	;MF;xݜN1n>s5Yib7p3@sўϫ4?%oCHT/%ȇ&
r $ڭTzob/:bR$\:nu9X.I9.0_bG{P=q~tc<ͽHt^\bZ@0glwztvȪZȠ0A.U'P@hk.х]]6+<P@6J"gV+u93ظD
u.ˡHPdmKDMSi"'䧧Gsƻ@A]zZR3irL|ujիVje%^PeS/׫T]qw(~(*'
5?Al!%J2ߓ;
Y`KU$+^X!BT(yc/jfz^WGKrw@jܯ/V_SOl:q*c:iM"I	Q>.YuEߋ}(]	/D4[4h1Tyy3?oT\%5˞ssSJ>z
w3d%ݳTbNT4;gQTy!|_d%CQNH9 kՓLFTgsfM+wɶxrp'PW2'sp抩Zh-xB['ӯw&ִT1D'Gƍ&E9̴dZdFXς;C.gSt^&;LPIpFE)Pdm{iPusF<7HG5ũDgL/sV$=<
M_4_8XV;wx%md;'WP^?'P_3}LqL6Yt5Ϧ0MFW=J%_d&[W,0S6^ǟ}['҂ppٺ|Bia"dZ1Шolz᬴$F@N9t3rANDSy
&D3S\8jmmokU'{`Ƹb>yD(Qn1vb||"l}.{O\\X!&صM"HI頠GWP !p!/gҭGO%/'?RFH?4͛e	1k;JH3pnzB&
X34B!)ZAвT٤
(Ya^,wJ.-)0[4kh)
G.qDh4-$V-.#W72/@ɨv";>{^Y?+UR-E4ֳYwhYggl%2"g2͞ZBmq$a%)hvIyWy'hqυ.C&YlQlB:0
	WԒ#Gϣ&y>DP.reGpXy]m~|w8@)38Np
 {O1ƨ? vNbsʈT)_h={,ۢ'ȟd*%3b̓ސIg!331A[j,WX}'J|cl̐/Uǆvt9iks|jLOa'SⅧBU
! EAMB,e\xn9B7fjGCb?I7C"%xE 0L;E!DLgp%M5$:}q'brV؊Ǐb^u_qA]CXz)$.%y[E}m+%NsD(3Hp#ܢ\p"I%9,:_Ow0ˆ2Eq@Aఁ\E!fEDNM4f\5h3V6&Idns;I1 hS1֞	aK.}=M6;	mD$x/UM^DqeC d3evuqLd7)NT5-	'\)Td_L%{	UM{,'\JavqCd+';HBX>웢Qf4E6
I9X7LxV@_y2(e\7K\L+qnƘb2.BdpŌ
(
"L/yYH;Itf,Ea,nK<2ￔZ^u=_֎r(Tζe9sݑ{u	f"dewt{X;>8BqE8`=^ j|}5K buu޶s":2A< g):c(vZE90,P7ADIL/iC-`R{1
H`?!$.MA'
ClD/z;4^ydCYǎ7̶d͚
;9KJ	QN^j+<yjsG43	/LXB.tv#Hz&`!*dѿ#kT1MSx67%|2Rda:
h,%%s+$\H$' 7r\
l/?,
To)+>8{)PhA"N9Uvpd+Zƴ
Gq!7Xp#CD>gdh-PⴜQ Hx|TygRpy9/N[㞐,b '7+hb@o/ݖ ⚛|E5C䀅 !v9W&M"[ir@!$[Zmqy#H|W8ή@9:ncӵ%r VǊ;ox!ށ <Q2ñ!&.rU/ @¯/m?yؐV6qI䎅u0ٔJ)ПX;0n51S"
n'wZr,tWaxӠ.!l{QA$QTA&Ը^1W; 4s*f6p DoH
(}=yP&ɳD5V"XSV
N*>U6J6 wO!EEHDA{DczM#tޥ p&_l
<a(<Ƞc~JH_/Kp/ FK3ޣ>8%b;Dg1! ЌDGXBuQ
(cM˃|F$2(jٛ ꃆIڣqWRɇPBɎh*fr(<D(*H9ľ>4]F7`yC9px^" pS( jĝ QA}s9	iB
)ٌC"ԱbpSÌ먔ģ#Ð7Ly0@ d%rv쓈9"
j(<HQZQStQT\ 矴t>iML!2ר38~)H_7{1N#?k8I¨j Mph$)IpKiȭ4AI h!!<QJZX I4h vn矿N"~S܁cC9Q2v$J# t!8x!]:PvJ@
s"C"ܶ󼠑)5c8ÅypB"dz5Thl.9x.X85qEEj+w8p^);zh<-ig?ɔWU38>;=/6ޅZ>6@s!+\v(mpc(QsL@KB̜Ov.ݍ:{"L w&Bs)>۽e%}R\;/Ak C	bh!% 36]۫#"4^$:a"VA4/)!|gjQM)A/!9c@
@ji@*(#ta ҖAroi((,A9
't6j*P^а	[hmE+EЇ+Io7ЁQ=G륂1e<ﾨՕҥcj{I V(:JsY

F6Ls16F; fA.NP:	(l)4QA8FMЁxt՜ɳ
9
030A
:rBN6]v t l!m.M64ZNx|n\b1ji5@Q
0@D4Ⱥtk]`]jMaQ}F+`s<Fa00U<xق?
M+}:Q1ʮecۋ4fi dz^&ÕOܐbu}_`)=FP%*ۡI TY*os~cBxrxh{}()(()
W
(J ltAm<ӕ:ft!t%\Q2i1tNi@@TE0L4guw:e0g
n_e72TUpۮdEwba8a#@(OCA.T>	}| >R!auZ~X(8&2rQ#f'Ci=
0#t)8:Q,&ZhCLC8"@f=xP; 
P;xE@ ubp˔ 	Dw?wav\AݬJc
'Gj\`a=/KR<@4ߓC@ (&䊝$@w@m<E@6N̎Xr!.PJB\gGp{"qlG_8~?)ka%S9Ef
Σb?&ܮsr3@a
&̈́h{J_P?cos~pwɰVkK	MeZ|\T3*Q'Pr]QɉP-ߴYґ~eu\C:p}K@6X%`'df#
H=_v#o>a5$ OթBL,AI!E	b{U'ס糈D-4
O$X_Pp6:N|mUT0DIU$CDԆhdla
	'МCBC֙qۃiu`9 ~·~=D%DHZ:wlafpxs(w?6pJSPn4C\P45Gy03<OSES\$AJLU%LUEUELUry=NS7@QEUEG@n
f3=6(	sC|DD#Yi@Y9R6
`IG4p3Dx0}HRPU@BgA%<#JEPmі P5^i)	H;G3Eb>'P(<	%02#QW#Ò(ΌWK6srB߂'TWCD| ?8aF9wuxX1A`i
%፭"Y0-+B,"h<eILC>i !Y$1+T^PT8\ޮ-v5UԸ}_q4Jq
mo&RJƃl52tqrZxX9((VCj@$4g(%40NcQ) M3P҈X,l8{]iaDTulWnc&]#OH[6@{6qہ	3	͇"Ó"PKA@w1=[@
6*uo|YbuɆmnfdћۉvl܃ƈcl}ˠ~ DAؤ_`slH@I
Cb.ӑ`qCSUl:n`),;M
P6m
OK9[!Zb|;es.> f7RRRahc%Hc
-`;8ȎN,f[cMx?drݻ18TSD]79BplE>ǌ⋹xm#t:Cf#`mH+C}7:}f?]q!}9Df?4r\Py~&dTy4p>`	
ghvHE
)jCA"yoD0xւ #Eh> /ΰ p*B(zl""r\l; 2
BVÀ  6-42t~Mu5/A
 `
S	(
SҞw	
f)q&DDoVJAQ$ == @>:t9Hƛ](pT i1v@HrnE4VD	~(
d e CP(W"D uil􆝷&ewD!{lB @0Gsw1Uyfwp\PVdT^!۵
}#p"mAx"$WyM)@:C͞9. EwǦHrqdaE/ih?S`KOlLxMbE=9
K(e~rQD2vE
T\jaKDP4D11
EYU"Eʏm3-]aiX<ǑbzY$a)kIl8g BIgy~3<pcAksEQݤ2!AzX#j'/<VI0D5BkHpHxrWfp$H
}r9U N۰	ğwWgYXUHT&r3& 1$ 4Na#"v>}:6&3"t|vQԚ()btơИUELL\m /L`z \0B~qu @F:z˨MxjLr(K-AW4fr'/O!0w~g>yB9,j0 f0QrI@3;:BSV:I[B!]y͌ݷ+>wo'\#XY1DzeU5A x94^D^S_vUaRT1ef#?>RE$iPWY⪃PaiJ<~B9ynLEkLz#9a
*\gxJ+.h&̵d3RFv7mLD:27R
8AeJ"F9mݐLpĠƍ\I+]H.KFRD<T+ar"\s?1	H^?
	asۃ$cUcy	\"6V E%Hlf64HzRRf3cg
rJ89bkEQ5DQcE޹wa#$!dC> 
Rp,IMhCkFc|OO&lvf3&i&`p1cۙreCbE*&pSbF"?14LW7ܧd&)-sg5*
-E@y3iXGE! Xv]$!*3r+&ul<]<7ZM")M!lZV+PuDQXFaV! iPǙ/XAP	!.m8G> ztEhI)+zq g<dvBBfc8H¢dQ[l6DY,[1
 x"!.P6601v!c(F76 g|ʪ,lqQ[|z6<M4E$QE6DQ㶸ss>l죻i{<6 ߺw㱳ApmcL0x)6]ec;2 ʆ62CqgY3U1ld$VJ~1fLH%Ħ4ggnؽ}rWM0)i
2a1FC!R=P֎Yt<J3pXɒ: *I$r`z_xMԒTCl{!I}JdFf
f0>zfvY63	Aa8Ԁj#}Dڵ,!qqlnx@! .[Knikj
#
nrQjPPU
R\
yO>I`$De},L=G$jq؁|Iv0x(8hUr9P NF|&X譖'7QS"}-ǔ"rBRT*S`Hz:@
:" A|hH<ɭUL/<$=+eah$Y'6/ F=bpq2wE%)ßk،|t@EȐތ]3	}STef伢D$@	Mwmigdkpae 9f~Æv%~$D*%-I/go
P,qcFc-$$ѷȺ$hʉn,Q:7єL]hK'b`Gn]A{(}"ؼ{OO<c0w>ݏ@"HrXOj;5R/i8DE֌H(XhHu	C<2DDdKQEUTS%S%UDc+ W6LISC`
D*aB $/9.%#:<?{8LIa4M|ȩ
iIco8 9,Gdo
cF'pB
'fq1,Mh(=60dA
4h9	D$aG9{[1;<s/烋GH5CF QYb\K,^-pqEQ(1Siv&>ꢓI6B8`{xHT}P2P,1~R{J8K0@SМc;Ga<^9yL&{urvr<sZR1?FdW^+ (~W\k|KI R(Φ֞gNE$M36;SDwp|L?n7f~=xw
Q
5mk$@?<	lShMeo%I.ns0ưԱ
IIPG`x>8a"@oyL/G
jY
;GQ.Wɏ+8t9wWQ ;8^8uRz"BmIQ`j9DOԤ+?g 0\9@_[J+݃m>i&@`pq	*Kҟ;uA9#Hg˓v|܂ĘG}N
А8(Ce !e%H%$IEQf--ic(AA"8l	9%J*23u" Z0OX!z.x'
 QtI9$B0]}͒LH/t W .woV2艝|!CdѼt\Bb\+6g_^֯P3$0X,OQ+˙G$uF>	;Ƒ@&bBt
|~LOkR R"cEF<|JY!hix?wylXB3B![܊J9dh%:5_W&/"*m
崛eB΢Ǒt-wNJc+QdhHi04&ꌀ>3l`ňNJA
D3
"I:t@ZŰ(?(_ь=ޗG8hOfH
qU:K[Ӹ:@u0NL"|xvbHz֔>"		
Fxԭh 3/V^gNg˚~2 Z,4J^	#B1&(zl!4$|̀FV> 
>6>Hy@\9b~"PPq66B!Q:ffV2Ӥ'L0̄x 4f":r
C5g@Bd(g/hW֞lBО:{ӌII}#(hwN疔Vf88-"})J1VR%cQ6,_^k'̴/q,qB0fFlCUׯ!1p`,2ŌBW^1(KP6q)bljѷM(7&'=Dt 2֙4b` AuZ7,cI~\Ք! BbSuJ;Z q3tSʢ=SBF3y	0Zte0Oa*Da2G
ȹxNGF7񐌤0_,hw+1#c-K8 UT/n`Ҩ8A~=s7^oQ"{<:k¸>NIn	AӾ_K
A o:K}q3G||n=Q}SHDI%Vsl9$#r2Wk(d[v|1e ;j~<rj!ab}谱4B`nN9w߸|`TYAќ9%IuX)Pm4J?0G$ۜĸddQMuo` BZd꘦()J s]4jAxn7gب>	^e t;pu?I4:r#w/C"3%a+h>.-7h;X >PD4=;G,ɲ]DOCN1(d:ɐXLE3qlwĹ|Ca@g&M8`49M:6*1ϒG	
JpML#(35K7?	(MbFՄPf%$0fq Y
s7F# -vE|;Q{Sb 1j(
C˽ijDAcT+HO`ЁDKqjƵa-M4F(3-sڅPdZbSZjhڌ_Q	ٿO?Kަas6\czH(V(pPyɫ ]1$jč8?"( O>c5(!HDIAion==cydKC0F9dpZ28:BAE#E(eI=+<%dHqUv잭YzLrշy+xa"I@4T`^Cq;ZZZ=g')ECyQ,А;'%a&%P
9I.B+(d
&#E;%"B
DM!M
L^yJs ĄDn҅(Z9o':>P̀͡ô@!̮W@2)Zwr͊@{D/5ݘ~9  6xi^vA#>2D6 ;pM@ z"?PxAT@E?5۷|r)]/:K%
o=JH{ 3Z}É$IGchu	QGVqbzSyR<	e'u9GE3w`tMQN=`tOo'|7~R2$b"~?Y:/]pZ]X$18Ì>wȉB}SbՐba֢e[aQNP{ů.h7QVAa30A^b T(TS:)w˧A%z]J7
%0]AlC ]W"+S>EO/D?-	QT}<!}j7(NC dɧҨCGw0pT{95rnqM>H%e
iA10QB)"1531Ԇ:60J@1dQH,B*j싦Oga`(18\.W	(
*=B	
{`yO4iSPn*	m!ԧ$"$@uzuA=EV;S$n
Y(1T4=!
9^hDwmG
%;#oV_p]AHT:NRo	cHaj(ExJKRj500ͽo"L:ğ ɤIv<q^Vhaj(ZU0Pl 8g]Xj-fzPHfN\SvhD
#^aķ5n|c($꾡(; 
l=~%s
~t^W@GC&mBiV+Ov ֯\Z9tk}S EP7ٳ%mLq%jFWɦ~%Vp( 0`%T!7p0mHAg49lvjKd"J:)1HH`!3	hr*T+#nK#5-: btMCpQqg)F4l*:\l-1\䌷cF.l2INxra{\⣴Rwԅ=6yږjTHEq
cT^&Bx`:̴'tX]7.1t+8+D vQ 󕼅L%&%bl4._CRD<?9J
9ND>;~ZFY1!ѣ%լt5y];Dm;$Ya_X{@CD~C".3[b`jE D6E :&e!d"mmY r

YT;))NxCPA鈢?a/
@6XKTC:` $ |To:U^Q!_>A<"*RCw ?*I=Uo5P2P&/IE=s߽d@د&px9q@ ]lu?A1Xo kHr&A@C(M(4A	**DA"T2@D@1"ݫ<g>Lܧ!C 9	Kl; RV/3p,ٙmQte0ݐ%	%Đ
|doxL	ñYN#[nC.U1,,#y"̀X5s/Myzߕt4xephS,	
s,#$Wzv
ki߈}D
\
tcvs838W, <r+|Cݝlpvzceqʛhcc#g@1]4I
}rG:5G_e'6g",(F1bWCW&4r[Q{5(76qa",Bv
?^ɜ7C>vW˫j(E 0C؛3 !FA2`g{g^ϙ6	"7C5^N'h$N
KwIANAf%1jn{g]ҢTq<%h!ɋc@x7@AlYg̓nCvԨ.(qBY
u@06OW0"C(	dwق20:Kf:lf|192:| "v PH!!uMߜSRDSbb6=:ik(:]*g6ש 8Fq̥?b)[yDi,.crƎ!Ft.,["Պ{/
(31E(bM5fC ?\K\;5Ed	uEUW:"5H*}y:0MTٔY@{ƇaU;]Ѵl%̷=R
FJ},0mz7zJZW0XĢu%P 'TFZ[-iV:8ښ	:pflmEK
pflΖ<A Q0kOLm dd'dJK(9Z)@ BXJQG%01cmIBrFpԋoi*RܡFe$00j#K4a\Ɏ`YsRh``c7h2$<RĞ`	Un(T	,B sjQX*h!&*% xaDm0;VI
Iu/ Bk"3puܸe&CnnqJ25sfF0P{
t0	=	- 
kL
m{¨@rRә
-T%LQrh7Sl9LLx*tD[!D=S td(@ NF;#4X͖';l0EOM-rw,j
t|]1,X'W坵ZDrj0kX9%2U삓cv,BX#pfs10l(1
P MQӈX
FX́	kE 	e $I%BXA	3AypvF
AήFU4R
0(`HٙtwX
k@QJUi_W2:djTInXevCHxFn\U8[
fpAz+ZE,ǝ4Kq3l6RYw
)T BYp1a
2D42  77`GHUP 2\aLC5:5D 3"&BCϵyz4b,8s:a |N	z%&~niPJGRDz^}Teء;ƻWX,+IP}<{LܫCEJF{gƇ"CkMuS!Hݢ*>6WʌW/kۑkI:C\n̄C8fuPTSiX{/x
B9<7 ~"zF@p:'_X6VێS!!0YCw/=P!,^Fg2Ȋ/SUUUU@1D 1D+<:RT5!2°xGOk2{.gUa39#Ć
6 S8)	V9@vo+{iA .zO!4%*^ 994

ś_s\*/9#7i	ZTF'p	bq1pL$[1$)@O;֢cofU5sOca*1pݯroV<a~)oYÀF0\t1bBKKK1AG~)ԂtE,D"!<:U_
\t iذ(ȠSOӴMaFο̿4b
EՁL HrƁ`#zGB16#)QIFT!Pl/`E=GQ)$hU4.(N/WQRE;0 Q4KyᏏ= D䔂  	@|<_0׻yD,r3*O9f gYf CDDLI,#H,@QࣳWALb%I1.lt="P1Nvl3 g *[#.)ۣTY$b#v <cQ)>ýN$I0WDO0|N^Cǩ3}?2G
uײf!ϥ= Ԙ AZ#I79@D+L!A~vkGUXfFH"aI/ЁB^|QN&KzG(Bn.4ȏj'A"ź?6$asLfXSieSGMvh%i"

ԔM$Gi@ Bj"{UJ\6jiVQ|)F4-_0013ELM-bJAPULDScc$IR!0JUH
p:{u0!i` "	XI^@oyoGyAl 2	Ǡ=r5FSռ2C 7 P
2LopA@!9SR&8̾}!Iu?"DbCZuP_X]B@l